<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('negocios','create');

$page_title = 'Novo Negócio';
$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

$erros = []; $sucesso = false; $novo_id = null;

/* Carrega clientes para o select (respeitando escopo de clientes) */
$clientes = [];
try {
    $scopeCli = function_exists('rbac_scope') ? rbac_scope('clientes','view') : 'all';
    if ($scopeCli === 'own') {
        $clientes = fetch_all(
            "SELECT id, nome_completo FROM clients WHERE (owner_user_id = ? OR (owner_user_id IS NULL AND created_by = ?)) ORDER BY nome_completo ASC",
            [$me_id, $me_id], true
        );
    } else {
        $clientes = fetch_all("SELECT id, nome_completo FROM clients ORDER BY nome_completo ASC", [], true);
    }
} catch (Throwable $e) { $clientes = []; }

/* Carrega imóveis (opcional; sem escopo por enquanto) */
$imoveis = [];
try {
    $imoveis = fetch_all("SELECT id, titulo FROM properties ORDER BY created_at DESC LIMIT 200", [], true);
} catch (Throwable $e) { $imoveis = []; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titulo        = trim($_POST['titulo'] ?? '');
    $client_id     = (int)($_POST['client_id'] ?? 0);
    $property_id   = ($_POST['property_id'] ?? '') !== '' ? (int)$_POST['property_id'] : null;
    $valor         = ($_POST['valor'] ?? '') !== '' ? (float)$_POST['valor'] : null;
    $etapa         = $_POST['etapa'] ?? 'novo';
    $prob          = ($_POST['prob'] ?? '') !== '' ? (int)$_POST['prob'] : null;
    $data_prevista = $_POST['data_prevista'] ?? null;

    if ($titulo === '')      { $erros[] = 'O título é obrigatório.'; }
    if ($client_id <= 0)     { $erros[] = 'Selecione um cliente.'; }
    if (!in_array($etapa, ['novo','qualificando','proposta','negociando','ganho','perdido'], true)) {
        $erros[] = 'Etapa inválida.';
    }

    if (!$erros) {
        try {
            execute(
                "INSERT INTO deals (titulo, client_id, property_id, valor, etapa, prob, data_prevista, owner_user_id, created_by)
                 VALUES (?,?,?,?,?,?,?,?,?)",
                [$titulo, $client_id, $property_id, $valor, $etapa, $prob, $data_prevista, $me_id, $me_id]
            );
            $novo_id = last_insert_id();
            $sucesso = true;
        } catch (Throwable $e) {
            $erros[] = 'Erro ao salvar: '.$e->getMessage();
        }
    }
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container mt-4 mb-5">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="fw-bold mb-0"><i class="bi bi-plus-circle text-primary me-2"></i>Novo Negócio</h1>
    <a href="<?=$BASE?>/negocios" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-2"></i>Voltar</a>
  </div>

  <?php if ($sucesso): ?>
    <div class="alert alert-success">
      <i class="bi bi-check-circle me-2"></i>Negócio criado com sucesso!
      <div class="mt-3">
        <a class="btn btn-success" href="<?=$BASE?>/negocios/<?=$novo_id?>/visualizar"><i class="bi bi-eye"></i> Ver</a>
        <a class="btn btn-outline-primary" href="<?=$BASE?>/negocios/<?=$novo_id?>/editar"><i class="bi bi-pencil"></i> Editar</a>
        <a class="btn btn-outline-secondary" href="<?=$BASE?>/negocios"><i class="bi bi-list"></i> Lista</a>
      </div>
    </div>
  <?php endif; ?>

  <?php if ($erros): ?>
    <div class="alert alert-danger"><ul class="mb-0"><?php foreach ($erros as $e) echo '<li>'.htmlspecialchars($e).'</li>'; ?></ul></div>
  <?php endif; ?>

  <?php if (!$sucesso): ?>
  <form method="POST" class="card p-4 shadow-sm">
    <div class="row g-3">
      <div class="col-md-8">
        <label class="form-label fw-bold">Título *</label>
        <input type="text" name="titulo" class="form-control" required value="<?=htmlspecialchars($_POST['titulo'] ?? '')?>">
      </div>
      <div class="col-md-4">
        <label class="form-label fw-bold">Valor</label>
        <input type="number" step="0.01" name="valor" class="form-control" value="<?=htmlspecialchars($_POST['valor'] ?? '')?>">
      </div>

      <div class="col-md-6">
        <label class="form-label fw-bold">Cliente *</label>
        <select name="client_id" class="form-select" required>
          <option value="">Selecione...</option>
          <?php foreach ($clientes as $c): ?>
            <option value="<?=$c['id']?>" <?= (isset($_POST['client_id']) && (int)$_POST['client_id']==(int)$c['id'])?'selected':'' ?>>
              <?=htmlspecialchars($c['nome_completo'])?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-6">
        <label class="form-label fw-bold">Imóvel (opcional)</label>
        <select name="property_id" class="form-select">
          <option value="">—</option>
          <?php foreach ($imoveis as $i): ?>
            <option value="<?=$i['id']?>" <?= (isset($_POST['property_id']) && (int)$_POST['property_id']==(int)$i['id'])?'selected':'' ?>>
              <?=htmlspecialchars($i['titulo'])?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-bold">Etapa</label>
        <select name="etapa" class="form-select">
          <?php
          $opts = ['novo'=>'Novo','qualificando'=>'Qualificando','proposta'=>'Proposta','negociando'=>'Negociando','ganho'=>'Ganho','perdido'=>'Perdido'];
          $cur  = $_POST['etapa'] ?? 'novo';
          foreach ($opts as $k=>$v) echo "<option value=\"$k\" ".($cur===$k?'selected':'').">$v</option>";
          ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label fw-bold">Probabilidade (%)</label>
        <input type="number" min="0" max="100" name="prob" class="form-control" value="<?=htmlspecialchars($_POST['prob'] ?? '')?>">
      </div>

      <div class="col-md-4">
        <label class="form-label fw-bold">Data prevista</label>
        <input type="date" name="data_prevista" class="form-control" value="<?=htmlspecialchars($_POST['data_prevista'] ?? '')?>">
      </div>

      <div class="col-12 mt-3">
        <button class="btn btn-primary"><i class="bi bi-check-circle me-2"></i>Salvar</button>
      </div>
    </div>
  </form>
  <?php endif; ?>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>