<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

/* RBAC */
rbac_require('admin','config_update');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

/* CSRF */
if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
$CSRF = $_SESSION['csrf'];

/* Helpers settings */
function get_setting($key, $default=null) {
  $r = fetch_one("SELECT value FROM settings WHERE `key` = ?", [$key], true);
  if (!$r) return $default;
  return $r['value'];
}
function set_setting($key, $value, $user_id=null) {
  $exists = fetch_one("SELECT `key` FROM settings WHERE `key` = ?", [$key], true);
  if ($exists) {
    execute("UPDATE settings SET value = ?, updated_by = ?, updated_at = NOW() WHERE `key` = ?", [$value, $user_id, $key]);
  } else {
    execute("INSERT INTO settings (`key`, value, updated_by, updated_at) VALUES (?, ?, ?, NOW())", [$key, $value, $user_id]);
  }
}

/* Load current */
$ALERT_ENABLED  = get_setting('alerts.enabled', '1');
$ALERT_DAYS     = get_setting('alerts.days_without_update', '3');
$ALERT_TARGET   = get_setting('alerts.target_roles', 'admin,gerente');

$ok = null; $err = null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
  try {
    if (!hash_equals($CSRF, (string)($_POST['csrf'] ?? ''))) { throw new Exception('CSRF inválido'); }
    // values
    $enabled = isset($_POST['enabled']) ? '1' : '0';
    $days    = (int)($_POST['days'] ?? 3);
    if ($days < 1) $days = 1;
    $roles = $_POST['roles'] ?? [];
    $roles = array_values(array_intersect($roles, ['admin','gerente']));
    $target = implode(',', $roles);

    set_setting('alerts.enabled', $enabled, $me_id);
    set_setting('alerts.days_without_update', (string)$days, $me_id);
    set_setting('alerts.target_roles', $target, $me_id);

    $ALERT_ENABLED = $enabled; $ALERT_DAYS = (string)$days; $ALERT_TARGET = $target;
    $ok = 'Configurações salvas.';
  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

$page_title = 'Admin • Configurações';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<style>
.form-help { color:#adb5bd; }
</style>

<div class="container my-4">
  <?php if ($ok): ?>
    <div class="alert alert-success alert-dismissible fade show"><i class="bi bi-check-circle me-2"></i><?=htmlspecialchars($ok)?><button class="btn-close" data-bs-dismiss="alert"></button></div>
  <?php endif; ?>
  <?php if ($err): ?>
    <div class="alert alert-danger alert-dismissible fade show"><i class="bi bi-exclamation-triangle me-2"></i><?=htmlspecialchars($err)?><button class="btn-close" data-bs-dismiss="alert"></button></div>
  <?php endif; ?>

  <h1 class="h4 mb-3"><i class="bi bi-sliders me-2"></i>Configurações</h1>

  <form method="post" class="card card-body">
    <input type="hidden" name="csrf" value="<?=$CSRF?>">
    <div class="row g-3">
      <div class="col-12">
        <div class="form-check form-switch">
          <input class="form-check-input" type="checkbox" id="enabled" name="enabled" value="1" <?= $ALERT_ENABLED==='1'?'checked':'' ?>>
          <label class="form-check-label" for="enabled">Ativar alertas de inatividade</label>
        </div>
        <div class="form-help">Quando um atendimento/cliente ficar X dias sem atualização, um alerta será sinalizado.</div>
      </div>

      <div class="col-md-4">
        <label class="form-label">Dias sem atualizar (X)</label>
        <input type="number" min="1" class="form-control" name="days" value="<?=htmlspecialchars($ALERT_DAYS)?>">
        <div class="form-help">Ex.: 3 dias</div>
      </div>

      <div class="col-md-8">
        <label class="form-label">Enviar alertas para</label>
        <?php $targets = array_filter(array_map('trim', explode(',', $ALERT_TARGET))); ?>
        <div class="d-flex gap-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="roles[]" value="admin" id="r-admin" <?= in_array('admin', $targets, true) ? 'checked':'' ?>>
            <label class="form-check-label" for="r-admin">Administradores</label>
          </div>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="roles[]" value="gerente" id="r-gerente" <?= in_array('gerente', $targets, true) ? 'checked':'' ?>>
            <label class="form-check-label" for="r-gerente">Gerentes</label>
          </div>
        </div>
        <div class="form-help">Essas funções receberão/visualizarão os alertas.</div>
      </div>
    </div>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary"><i class="bi bi-check2-circle me-1"></i>Salvar</button>
      <a class="btn btn-secondary" href="<?=$BASE?>/admin"><i class="bi bi-arrow-left"></i> Voltar</a>
    </div>
  </form>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
