<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: login.php");
    exit;
}

require_once __DIR__ . '/app/db.php';
require_once __DIR__ . '/app/rbac.php';

$page_title = 'Dashboard';

// ===================== Estatísticas existentes =====================
$imoveis_publicados = 0;
$imoveis_total = 0;
$total_clientes = 0;
$ultimos_imoveis = [];
$ultimos_clientes = [];
$conexao_ok = true;
$erro_db = null;

// ===================== NOVAS MÉTRICAS (Atendimentos/Alertas/Top/Tarefas) =====================
$me_id       = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);
$scopeAt     = function_exists('rbac_scope') ? rbac_scope('atendimentos','view') : 'all'; // own|all
$ownerWhere  = '';
$ownerParams = [];

if ($scopeAt === 'own') {
    $ownerWhere  = " AND (i.owner_user_id = ? OR (i.owner_user_id IS NULL AND i.created_by = ?)) ";
    $ownerParams = [$me_id, $me_id];
}

// Lê dias de alerta (settings -> fallback system_configs -> fallback 3)
$alert_days = 3;
try {
    $r = fetch_one("SELECT value FROM settings WHERE `key`='alerts.days_without_update' LIMIT 1", [], true);
    if ($r && is_numeric($r['value'])) $alert_days = max(1, (int)$r['value']);
} catch (Throwable $e) {
    try {
        $r2 = fetch_one("SELECT `value` FROM system_configs WHERE `key`='alerts_inactivity_days' LIMIT 1", [], true);
        if ($r2 && is_numeric($r2['value'])) $alert_days = max(1, (int)$r2['value']);
    } catch (Throwable $e2) {}
}

$atend_abertos       = 0;
$followups_hoje      = 0;
$followups_atrasados = 0;
$alertas_qtd         = 0;
$recent_acts         = [];

$top_corretores = [];   // [{nome, logs}]
$minhas_logs_7d = 0;    // se visão own

$tasks_by_day   = [];   // prox 7 dias: [['d'=>'YYYY-MM-DD','c'=>N], ...]
$tasks_today    = [];   // hoje (detalhe)

try {
    // Conexão OK?
    db()->query("SELECT 1");
    $imoveis_publicados = count_properties('publicado');
    $imoveis_total      = count_properties();
    $total_clientes     = count_clients();
    $ultimos_imoveis    = get_recent_properties(5);
    $ultimos_clientes   = get_recent_clients(5);

    // ========== Atendimentos Abertos ==========
    $sqlOpen = "SELECT COUNT(*) c
                  FROM interactions i
                 WHERE i.status <> 'finalizado' " . $ownerWhere;
    $rowOpen = fetch_one($sqlOpen, $ownerParams, true);
    $atend_abertos = (int)($rowOpen['c'] ?? 0);

    // ========== Follow-ups (Hoje / Atrasados) ==========
    $sqlHoje = "SELECT COUNT(*) c
                  FROM interactions i
                 WHERE i.status <> 'finalizado'
                   AND i.next_followup_at IS NOT NULL
                   AND DATE(i.next_followup_at) = CURDATE()
                 " . $ownerWhere;
    $rowHoje = fetch_one($sqlHoje, $ownerParams, true);
    $followups_hoje = (int)($rowHoje['c'] ?? 0);

    $sqlAtraso = "SELECT COUNT(*) c
                    FROM interactions i
                   WHERE i.status <> 'finalizado'
                     AND i.next_followup_at IS NOT NULL
                     AND i.next_followup_at < NOW()
                 " . $ownerWhere;
    $rowAtr = fetch_one($sqlAtraso, $ownerParams, true);
    $followups_atrasados = (int)($rowAtr['c'] ?? 0);

    // ========== Alertas de Inatividade ==========
    $paramsAlert = array_merge([$alert_days], $ownerParams);
    $sqlAlert = "
      SELECT COUNT(*) AS c
        FROM interactions i
       WHERE i.status <> 'finalizado'
         AND (i.alerts_snooze_until IS NULL OR i.alerts_snooze_until < NOW())
         AND TIMESTAMPDIFF(
               DAY,
               COALESCE(
                 (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
                 i.last_activity_at,
                 i.updated_at,
                 i.created_at
               ),
               NOW()
             ) >= ?
             $ownerWhere
    ";
    try {
        $rowAl = fetch_one($sqlAlert, $paramsAlert, true);
    } catch (Throwable $e) {
        // fallback se last_activity_at não existir
        $sqlAlert = "
          SELECT COUNT(*) AS c
            FROM interactions i
           WHERE i.status <> 'finalizado'
             AND (i.alerts_snooze_until IS NULL OR i.alerts_snooze_until < NOW())
             AND TIMESTAMPDIFF(
                   DAY,
                   COALESCE(
                     (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
                     i.updated_at,
                     i.created_at
                   ),
                   NOW()
                 ) >= ?
                 $ownerWhere
        ";
        $rowAl = fetch_one($sqlAlert, $paramsAlert, true);
    }
    $alertas_qtd = (int)($rowAl['c'] ?? 0);

    // ========== Atividades Recentes (últimas 10 timelines) ==========
    $paramsAct = $ownerParams;
    $whereAct  = $ownerWhere ? (" AND (" . substr($ownerWhere, 5) . ") ") : ""; // reaproveita condição removendo "AND "
    $recent_acts = fetch_all("
      SELECT l.id, l.interaction_id, l.created_at, l.nota,
             c.nome_completo AS cliente_nome,
             u.nome          AS owner_nome
        FROM interaction_logs l
        JOIN interactions i ON i.id = l.interaction_id
   LEFT JOIN clients      c ON c.id = i.client_id
   LEFT JOIN users        u ON u.id = i.owner_user_id
       WHERE 1=1 $whereAct
    ORDER BY l.created_at DESC
       LIMIT 10
    ", $paramsAct, true) ?: [];

    // ========== Top Corretores (7 dias) ==========
    if ($scopeAt === 'all') {
        $top_corretores = fetch_all("
            SELECT u.id, u.nome, COUNT(l.id) AS logs_7d
              FROM interaction_logs l
              JOIN interactions i ON i.id = l.interaction_id
         LEFT JOIN users        u ON u.id = i.owner_user_id
             WHERE l.created_at >= (NOW() - INTERVAL 7 DAY)
          GROUP BY u.id, u.nome
          ORDER BY logs_7d DESC, u.nome ASC
             LIMIT 5
        ", [], true) ?: [];
    } else {
        $rMy = fetch_one("
            SELECT COUNT(l.id) AS logs_7d
              FROM interaction_logs l
              JOIN interactions i ON i.id = l.interaction_id
             WHERE l.created_at >= (NOW() - INTERVAL 7 DAY)
               AND (i.owner_user_id = ? OR (i.owner_user_id IS NULL AND i.created_by = ?))
        ", [$me_id,$me_id], true);
        $minhas_logs_7d = (int)($rMy['logs_7d'] ?? 0);
    }

    // ========== Tarefas por dia (próximos 7 dias) ==========
    $tasks_by_day = fetch_all("
        SELECT DATE(i.next_followup_at) AS d, COUNT(*) AS c
          FROM interactions i
         WHERE i.status <> 'finalizado'
           AND i.next_followup_at IS NOT NULL
           AND i.next_followup_at >= CURDATE()
           AND i.next_followup_at <  (CURDATE() + INTERVAL 7 DAY)
               $ownerWhere
      GROUP BY DATE(i.next_followup_at)
      ORDER BY d ASC
    ", $ownerParams, true) ?: [];

    // Hoje (detalhe – até 10)
    $tasks_today = fetch_all("
        SELECT i.id, i.next_followup_at,
               c.nome_completo AS cliente_nome,
               u.nome          AS owner_nome
          FROM interactions i
     LEFT JOIN clients c ON c.id = i.client_id
     LEFT JOIN users   u ON u.id = i.owner_user_id
         WHERE i.status <> 'finalizado'
           AND i.next_followup_at IS NOT NULL
           AND DATE(i.next_followup_at) = CURDATE()
               $ownerWhere
      ORDER BY i.next_followup_at ASC
         LIMIT 10
    ", $ownerParams, true) ?: [];

} catch (Exception $e) {
    $conexao_ok = false;
    $erro_db = $e->getMessage();
}

include __DIR__ . '/layout/header.php';
include __DIR__ . '/layout/nav.php';
?>

<!-- ======== APENAS ESTA PARTE NOVA (CSS) ======== -->
<style>
  .dashboard-list-dark .list-group-item{
    background: transparent;
    color: var(--bs-light);
    border-color: rgba(255,255,255,.08);
    padding-top: .75rem;
    padding-bottom: .75rem;
  }
  .dashboard-list-dark .list-group-item:hover{
    background: rgba(255,255,255,.03);
  }
</style>
<!-- ============================================== -->

<div class="container mt-4 mb-5">
    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
        <div>
            <h1 class="mb-1 fw-bold">
                <i class="bi bi-speedometer2 me-2"></i>Dashboard
            </h1>
            <p class="text-muted mb-0">Bem-vindo de volta, <?php echo htmlspecialchars($_SESSION["user_name"] ?? 'Usuário'); ?>!</p>
        </div>
        
        <div class="d-flex align-items-center gap-2 flex-wrap">
            <?php if ($conexao_ok): ?>
                <span class="badge bg-success fs-6 px-3 py-2">
                    <i class="bi bi-check-circle-fill me-1"></i>
                    Banco Conectado
                </span>
            <?php else: ?>
                <span class="badge bg-danger fs-6 px-3 py-2">
                    <i class="bi bi-x-circle-fill me-1"></i>
                    Erro de Banco
                </span>
            <?php endif; ?>
            
            <a href="teste_conexao.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-plug me-1"></i>Testar Conexão
            </a>
        </div>
    </div>

    <?php if ($erro_db): ?>
        <div class="alert alert-danger mb-4">
            <h5 class="mb-2"><i class="bi bi-exclamation-triangle-fill me-2"></i>Erro de Conexão</h5>
            <p class="mb-3"><?php echo htmlspecialchars($erro_db); ?></p>
        </div>
    <?php endif; ?>

    <!-- ESTATÍSTICAS -->
    <div class="row g-4 mb-5">
        <div class="col-lg-3 col-md-6">
            <a href="<?php echo BASE_URL; ?>/imoveis" class="stat-card card text-decoration-none">
                <div class="card-body text-center">
                    <i class="bi bi-building display-4 text-success"></i>
                    <h2 class="mt-3 mb-1"><?php echo $imoveis_publicados; ?></h2>
                    <p class="text-muted mb-0">Imóveis Publicados</p>
                    <small class="text-success fw-semibold">
                        <?php echo max(0, $imoveis_total - $imoveis_publicados); ?> em rascunho
                    </small>
                </div>
            </a>
        </div>

        <div class="col-lg-3 col-md-6">
            <a href="<?php echo BASE_URL; ?>/clientes" class="stat-card card text-decoration-none">
                <div class="card-body text-center">
                    <i class="bi bi-people display-4 text-primary"></i>
                    <h2 class="mt-3 mb-1"><?php echo $total_clientes; ?></h2>
                    <p class="text-muted mb-0">Total de Clientes</p>
                    <small class="text-primary fw-semibold">
                        Cadastrados no sistema
                    </small>
                </div>
            </a>
        </div>

        <!-- Atendimentos Abertos -->
        <div class="col-lg-3 col-md-6">
            <a href="<?php echo BASE_URL; ?>/atendimentos" class="stat-card card text-decoration-none">
                <div class="card-body text-center">
                    <i class="bi bi-headset display-4 text-info"></i>
                    <h2 class="mt-3 mb-1"><?php echo $atend_abertos; ?></h2>
                    <p class="text-muted mb-0">Atendimentos Abertos</p>
                    <small class="text-info fw-semibold">
                        <?php echo $followups_hoje; ?> hoje &middot; <?php echo $followups_atrasados; ?> em atraso
                    </small>
                </div>
            </a>
        </div>

        <!-- Alertas de Inatividade -->
        <div class="col-lg-3 col-md-6">
            <a href="<?php echo BASE_URL; ?>/admin/alertas" class="stat-card card text-decoration-none">
                <div class="card-body text-center">
                    <i class="bi bi-bell display-4 text-warning"></i>
                    <h2 class="mt-3 mb-1"><?php echo $alertas_qtd; ?></h2>
                    <p class="text-muted mb-0">Alertas de Inatividade</p>
                    <small class="text-warning fw-semibold">
                        ≥ <?php echo (int)$alert_days; ?> dia(s) sem atualização
                    </small>
                </div>
            </a>
        </div>
    </div>

    <?php if ($conexao_ok): ?>
        <!-- RECENTES -->
        <div class="row g-4">
            <!-- ÚLTIMOS IMÓVEIS -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-house-door me-2 text-success"></i>
                            Últimos Imóveis
                        </h5>
                        <a href="<?php echo BASE_URL; ?>/imoveis" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-grid me-1"></i>Ver Todos
                        </a>
                    </div>
                    
                    <div class="card-body p-0">
                        <?php if (empty($ultimos_imoveis)): ?>
                            <div class="empty-state">
                                <i class="bi bi-house-door"></i>
                                <h5>Nenhum imóvel cadastrado</h5>
                                <p>Comece adicionando seu primeiro imóvel ao sistema!</p>
                                <a href="<?php echo BASE_URL; ?>/imoveis/novo" class="btn btn-success">
                                    <i class="bi bi-plus-circle me-2"></i>Cadastrar Imóvel
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-dark table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th>Título</th>
                                            <th>Preço</th>
                                            <th>Cidade</th>
                                            <th>Status</th>
                                            <th>Data</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($ultimos_imoveis as $imovel): ?>
                                        <tr>
                                            <td><strong><?php echo htmlspecialchars($imovel['titulo']); ?></strong></td>
                                            <td><span class="text-success fw-bold"><?php echo format_money($imovel['preco']); ?></span></td>
                                            <td><?php echo htmlspecialchars($imovel['cidade']); ?></td>
                                            <td>
                                                <span class="badge <?php 
                                                    echo $imovel['status'] === 'publicado' ? 'bg-success' : 
                                                         ($imovel['status'] === 'rascunho' ? 'bg-warning text-dark' : 'bg-secondary');
                                                ?>">
                                                    <?php echo ucfirst($imovel['status']); ?>
                                                </span>
                                            </td>
                                            <td><small class="text-muted"><?php echo date('d/m/Y', strtotime($imovel['created_at'])); ?></small></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- ÚLTIMOS CLIENTES -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-people me-2 text-primary"></i>
                            Últimos Clientes
                        </h5>
                        <a href="<?php echo BASE_URL; ?>/clientes" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-people me-1"></i>Ver Todos
                        </a>
                    </div>
                    
                    <div class="card-body p-0">
                        <?php if (empty($ultimos_clientes)): ?>
                            <div class="empty-state">
                                <i class="bi bi-person-plus"></i>
                                <h5>Nenhum cliente cadastrado</h5>
                                <p>Adicione seu primeiro cliente para começar!</p>
                                <a href="<?php echo BASE_URL; ?>/clientes/criar" class="btn btn-success">
                                    <i class="bi bi-plus-circle me-2"></i>Cadastrar Cliente
                                </a>
                            </div>
                        <?php else: ?>
                            <ul class="list-group list-group-flush dashboard-list-dark">
                                <?php foreach ($ultimos_clientes as $cliente): 
                                    $nomeCliente = $cliente['nome_completo'] ?? $cliente['nome'] ?? '(sem nome)';
                                    $waRaw = $cliente['whatsapp'] 
                                             ?? $cliente['telefone_whatsapp'] 
                                             ?? $cliente['celular'] 
                                             ?? $cliente['telefone'] 
                                             ?? null;
                                    $waDigits = $waRaw ? preg_replace('/\D/', '', (string)$waRaw) : '';
                                ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong><?php echo htmlspecialchars($nomeCliente); ?></strong>
                                        <?php if (!empty($cliente['email'])): ?>
                                            <br><small><?php echo htmlspecialchars($cliente['email']); ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ($waDigits): ?>
                                        <a href="https://wa.me/55<?php echo $waDigits; ?>" 
                                           class="btn btn-sm btn-success" target="_blank" title="WhatsApp">
                                            <i class="bi bi-whatsapp"></i>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- ATIVIDADES RECENTES -->
        <div class="row g-4 mt-1">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-clock-history me-2 text-info"></i>
                            Atividades Recentes
                        </h5>
                        <a href="<?php echo BASE_URL; ?>/atendimentos" class="btn btn-sm btn-outline-light">
                            <i class="bi bi-headset me-1"></i>Abrir Atendimentos
                        </a>
                    </div>
                    <div class="card-body p-0">
                        <?php if (empty($recent_acts)): ?>
                            <div class="empty-state">
                                <i class="bi bi-inbox"></i>
                                <h5>Sem atividades recentes</h5>
                                <p>Quando houver novas notas/timelines, elas aparecem aqui.</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-dark table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th style="width:160px">Data</th>
                                            <th>Cliente</th>
                                            <th>Nota / Ação</th>
                                            <th style="width:220px">Responsável</th>
                                            <th style="width:120px" class="text-end">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recent_acts as $a): ?>
                                            <tr>
                                                <td><small class="text-muted"><?php echo date('d/m/Y H:i', strtotime($a['created_at'])); ?></small></td>
                                                <td><strong><?php echo htmlspecialchars($a['cliente_nome'] ?? '—'); ?></strong></td>
                                                <td>
                                                    <?php 
                                                    $nota = trim((string)($a['nota'] ?? ''));
                                                    if ($nota === '') echo '<span class="text-muted">—</span>';
                                                    else {
                                                        $cut = mb_strlen($nota) > 140 ? (mb_substr($nota,0,140).'…') : $nota;
                                                        echo htmlspecialchars($cut);
                                                    }
                                                    ?>
                                                </td>
                                                <td><?php echo htmlspecialchars($a['owner_nome'] ?? '—'); ?></td>
                                                <td class="text-end">
                                                    <a class="btn btn-sm btn-outline-light" 
                                                       href="<?php echo BASE_URL; ?>/atendimentos/visualizar?id=<?php echo (int)($a['interaction_id'] ?? 0); ?>">
                                                        <i class="bi bi-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- NOVO BLOCO: TOP CORRETORES + TAREFAS POR DIA -->
        <div class="row g-4 mt-1">
            <!-- TOP CORRETORES -->
            <div class="col-lg-4">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-trophy me-2 text-warning"></i>
                            Top Corretores (7d)
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if ($scopeAt === 'all'): ?>
                            <?php if (empty($top_corretores)): ?>
                                <div class="empty-state">
                                    <i class="bi bi-emoji-neutral"></i>
                                    <h6>Sem dados no período</h6>
                                    <p class="mb-0">Nenhuma atualização de atendimento registrada nos últimos 7 dias.</p>
                                </div>
                            <?php else: ?>
                                <ol class="list-group list-group-numbered">
                                    <?php foreach ($top_corretores as $tc): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span><?php echo htmlspecialchars($tc['nome'] ?? '—'); ?></span>
                                            <span class="badge bg-primary rounded-pill"><?php echo (int)$tc['logs_7d']; ?></span>
                                        </li>
                                    <?php endforeach; ?>
                                </ol>
                            <?php endif; ?>
                        <?php else: ?>
                            <div class="text-center">
                                <div class="display-6 fw-bold"><?php echo (int)$minhas_logs_7d; ?></div>
                                <div class="text-muted">suas atualizações (7 dias)</div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- TAREFAS POR DIA -->
            <div class="col-lg-8">
                <div class="card h-100">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-calendar-week me-2 text-info"></i>
                            Tarefas por Dia (próx. 7 dias)
                        </h5>
                        <a href="<?php echo BASE_URL; ?>/atendimentos" class="btn btn-sm btn-outline-primary">
                            Ver Lista
                        </a>
                    </div>
                    <div class="card-body">
                        <?php if (empty($tasks_by_day) && empty($tasks_today)): ?>
                            <div class="empty-state">
                                <i class="bi bi-clipboard-check"></i>
                                <h6>Nenhuma tarefa planejada</h6>
                                <p class="mb-0">Use "Próxima ação" nos atendimentos para organizar seu dia.</p>
                            </div>
                        <?php else: ?>
                            <!-- Mini calendário -->
                            <div class="table-responsive mb-3">
                                <table class="table table-dark table-sm align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th style="width:140px">Data</th>
                                            <th>Quantidade</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Normaliza array por data para exibição estável
                                        $byDate = [];
                                        foreach ($tasks_by_day as $t) {
                                            $byDate[$t['d']] = (int)$t['c'];
                                        }
                                        for ($i=0;$i<7;$i++) {
                                            $d = date('Y-m-d', strtotime("+$i day"));
                                            $c = $byDate[$d] ?? 0;
                                            echo '<tr><td>'.date('d/m/Y', strtotime($d)).'</td><td>'.$c.'</td></tr>';
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Hoje (detalhe) -->
                            <h6 class="mt-3 mb-2"><i class="bi bi-calendar-day me-1"></i>Tarefas de hoje</h6>
                            <?php if (empty($tasks_today)): ?>
                                <div class="text-muted">Nenhuma tarefa marcada para hoje.</div>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-dark table-hover align-middle mb-0">
                                        <thead>
                                            <tr>
                                                <th style="width:110px">Hora</th>
                                                <th>Cliente</th>
                                                <th style="width:220px">Responsável</th>
                                                <th style="width:100px" class="text-end">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($tasks_today as $t): ?>
                                                <tr>
                                                    <td><small class="text-muted"><?php echo date('H:i', strtotime($t['next_followup_at'])); ?></small></td>
                                                    <td><strong><?php echo htmlspecialchars($t['cliente_nome'] ?? '—'); ?></strong></td>
                                                    <td><?php echo htmlspecialchars($t['owner_nome'] ?? '—'); ?></td>
                                                    <td class="text-end">
                                                        <a class="btn btn-sm btn-outline-light" 
                                                           href="<?php echo BASE_URL; ?>/atendimentos/visualizar?id=<?php echo (int)$t['id']; ?>">
                                                            <i class="bi bi-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- PRÓXIMOS PASSOS -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="bi bi-lightbulb me-2 text-warning"></i>
                            Próximos Passos
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 rounded bg-success bg-opacity-10">
                                    <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-check-lg"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Conexão OK</h6>
                                        <small>Banco de dados conectado com sucesso</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 rounded bg-warning bg-opacity-10">
                                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-plus-circle"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Adicionar Conteúdo</h6>
                                        <small>Cadastre imóveis e clientes</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 rounded bg-info bg-opacity-10">
                                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-gear"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Configurar Site</h6>
                                        <small>Integre com troyasite</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- INSTRUÇÕES DE INSTALAÇÃO -->
        <div class="alert alert-warning">
            <h5><i class="bi bi-exclamation-triangle me-2"></i>Erro de Conexão com Banco</h5>
            <p class="mb-2">Complete a configuração seguindo estes passos:</p>
            <ol class="mb-0">
                <li>Verifique as credenciais em <code>config/config.php</code></li>
                <li>Confirme que o banco <code>ztr_troya_crm</code> existe</li>
                <li>Teste a conexão novamente</li>
            </ol>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/layout/footer.php'; ?>