<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

$page_title = 'Agenda';
$active     = 'agenda';

rbac_require('agenda','view');

$BASE   = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id  = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

/** Escopo do viewer: 'own' | 'all' (admin devolve 'all') */
$scopeView = rbac_scope('agenda','view');

/** Mostrar coluna de responsável apenas quando se enxerga agendas de outros */
$role = strtolower($_SESSION['user']['role'] ?? '');
$showOwnerCol = ($scopeView === 'all') || $role === 'gerente'; // admin já cai em 'all'

$params = [];
$sql = "SELECT 
            a.id,
            a.titulo,
            a.inicio,
            a.fim,
            a.obs,
            a.owner_user_id,
            p.titulo AS property_titulo,
            c.nome_completo AS cliente_nome,
            COALESCE(u.nome, u.email) AS responsavel_nome,
            u.email AS responsavel_email
        FROM agenda a
        LEFT JOIN properties p ON p.id = a.property_id
        LEFT JOIN clients    c ON c.id = a.client_id
        LEFT JOIN users      u ON u.id = a.owner_user_id";

if ($scopeView === 'own') {
    $sql .= " WHERE a.owner_user_id = ?";
    $params[] = $me_id;
}

$sql .= " ORDER BY a.inicio DESC LIMIT 100";

$itens = [];
$erro  = null;
try {
    $itens = fetch_all($sql, $params, true);
} catch (Throwable $e) {
    $erro = $e->getMessage();
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-calendar-event" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Agenda</h1>
      </div>
      <div class="text-muted small mt-1">
        <?= $showOwnerCol ? 'Compromissos (todos)' : 'Seus compromissos' ?>
      </div>
    </div>
    <div class="d-flex gap-2">
      <?php if (rbac_can('agenda','create')): ?>
        <a href="<?=$BASE?>/modules/agenda/novo.php" class="btn btn-success">
          <i class="bi bi-plus-lg"></i> Novo compromisso
        </a>
      <?php endif; ?>
      <a href="<?=$BASE?>/modules/agenda/calendario.php" class="btn btn-outline-secondary">
        <i class="bi bi-calendar3"></i> Calendário
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Lista</div>
    <div class="card-body">
      <?php if ($erro): ?>
        <div class="alert alert-danger"><strong>Erro:</strong> <?=htmlspecialchars($erro)?></div>
      <?php endif; ?>

      <?php if (!$itens): ?>
        <div class="empty-state">
          <i class="bi bi-calendar2-x"></i>
          <h5>Nenhum compromisso</h5>
          <p>Crie um novo compromisso para começar.</p>
          <?php if (rbac_can('agenda','create')): ?>
            <a href="<?=$BASE?>/modules/agenda/novo.php" class="btn btn-success">
              <i class="bi bi-plus-lg"></i> Novo compromisso
            </a>
          <?php endif; ?>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-dark table-hover align-middle mb-0">
            <thead>
              <tr>
                <th style="width:80px">ID</th>
                <th>Título</th>
                <th style="width:200px">Início</th>
                <th style="width:200px">Fim</th>
                <th class="d-none d-md-table-cell">Cliente</th>
                <th class="d-none d-md-table-cell">Imóvel</th>
                <?php if ($showOwnerCol): ?>
                  <th class="d-none d-lg-table-cell">Responsável</th>
                <?php endif; ?>
                <th class="text-end" style="width:230px">Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($itens as $r):
                // checagens por linha (update/delete respeitando escopo)
                $canUpd = false; $canDel = false;
                if (rbac_can('agenda','update')) {
                    $su = rbac_scope('agenda','update');
                    $canUpd = ($su === 'all') || ($su === 'own' && (int)$r['owner_user_id'] === $me_id);
                }
                if (rbac_can('agenda','delete')) {
                    $sd = rbac_scope('agenda','delete');
                    $canDel = ($sd === 'all') || ($sd === 'own' && (int)$r['owner_user_id'] === $me_id);
                }

                $respNome = trim((string)($r['responsavel_nome'] ?? ''));
                if ($respNome === '' && !empty($r['owner_user_id'])) {
                    $respNome = 'Usuário #'.(int)$r['owner_user_id'];
                }
              ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td>
                  <strong><?= htmlspecialchars($r['titulo']) ?></strong>
                  <?php if (!empty($r['obs'])): ?>
                    <br><small class="text-muted"><?= htmlspecialchars(mb_strimwidth($r['obs'],0,80,'…','UTF-8')) ?></small>
                  <?php endif; ?>
                </td>
                <td><?= $r['inicio'] ? date('d/m/Y H:i', strtotime($r['inicio'])) : '-' ?></td>
                <td><?= $r['fim']    ? date('d/m/Y H:i', strtotime($r['fim']))    : '-' ?></td>
                <td class="d-none d-md-table-cell"><?= htmlspecialchars($r['cliente_nome'] ?? '-') ?></td>
                <td class="d-none d-md-table-cell"><?= htmlspecialchars($r['property_titulo'] ?? '-') ?></td>

                <?php if ($showOwnerCol): ?>
                  <td class="d-none d-lg-table-cell">
                    <?php if (!empty($r['responsavel_email'])): ?>
                      <a href="mailto:<?= htmlspecialchars($r['responsavel_email']) ?>">
                        <?= htmlspecialchars($respNome) ?>
                      </a>
                    <?php else: ?>
                      <?= htmlspecialchars($respNome ?: '-') ?>
                    <?php endif; ?>
                  </td>
                <?php endif; ?>

                <td class="text-end">
                  <div class="btn-group">
                    <?php if ($canUpd): ?>
                      <a class="btn btn-sm btn-outline-secondary" href="<?=$BASE?>/modules/agenda/editar.php?id=<?= (int)$r['id'] ?>">
                        <i class="bi bi-pencil"></i> Editar
                      </a>
                    <?php endif; ?>
                    <?php if ($canDel): ?>
                      <a class="btn btn-sm btn-outline-danger" href="<?=$BASE?>/modules/agenda/remover.php?id=<?= (int)$r['id'] ?>"
                         onclick="return confirm('Remover este compromisso?');">
                        <i class="bi bi-trash"></i> Excluir
                      </a>
                    <?php endif; ?>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>