<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once __DIR__ . '/../../app/db.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$redirect = isset($_GET['redirect']) ? $_GET['redirect'] : 'index.php';

if ($id <= 0) {
    header("Location: {$redirect}?erro=ID inválido");
    exit;
}

try {
    // Buscar imóvel para confirmação
    $imovel = fetch_one("SELECT titulo FROM properties WHERE id = ?", [$id], true);
    
    if (!$imovel) {
        header("Location: {$redirect}?erro=Imóvel não encontrado");
        exit;
    }
    
    // Verificar se é POST (confirmação)
    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        execute("DELETE FROM properties WHERE id = ?", [$id]);
        header("Location: {$redirect}?sucesso=Imóvel excluído com sucesso");
        exit;
    }
    
} catch (Exception $e) {
    header("Location: {$redirect}?erro=Erro ao processar exclusão: " . urlencode($e->getMessage()));
    exit;
}

// Redirecionar para confirmação se não for POST
header("Location: index.php?confirmar_exclusao=" . $id);
exit;
?>
