<?php
require_once __DIR__ . '/../../app/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// título e aba ativa (usados pelo layout/nav)
$page_title = 'Editar compromisso';
$active     = 'agenda';

// PDO resiliente
$__pdo = null;
if (function_exists('db')) { $__pdo = db(); }
elseif (isset($pdo) && $pdo instanceof PDO) { $__pdo = $pdo; }
elseif (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $__pdo = $GLOBALS['pdo']; }
else { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_one($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);$st->execute($p);$r=$st->fetchAll(PDO::FETCH_ASSOC);return $r?$r[0]:null;}
function q_all($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);$st->execute($p);return $st->fetchAll(PDO::FETCH_ASSOC);}
function q_exec($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);return $st->execute($p);}
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

// ---------- CARREGA REGISTRO ----------
$id = (int)($_GET['id'] ?? 0);
$ag = $id ? q_one("SELECT * FROM agenda WHERE id = ?", [$id]) : null;
if (!$ag) { http_response_code(404); exit('Registro não encontrado'); }

// ---------- PROCESSA POST ANTES DO HEADER (para permitir redirect) ----------
$errors = [];
$titulo = trim($_POST['titulo'] ?? $ag['titulo']);
$inicio = trim($_POST['inicio'] ?? $ag['inicio']);
$fim    = trim($_POST['fim'] ?? $ag['fim']);
$property_id = isset($_POST['property_id']) ? (($_POST['property_id']!=='') ? (int)$_POST['property_id'] : null) : $ag['property_id'];
$client_id   = isset($_POST['client_id'])   ? (($_POST['client_id']  !=='') ? (int)$_POST['client_id']   : null) : $ag['client_id'];
$obs = trim($_POST['obs'] ?? ($ag['obs'] ?? ''));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if ($titulo === '') $errors[] = 'Informe o título';
  if ($inicio === '') $errors[] = 'Informe a data/hora inicial';

  // (opcional) validação simples: fim >= início, se ambos informados
  if ($inicio !== '' && $fim !== '') {
    $tInicio = strtotime($inicio);
    $tFim    = strtotime($fim);
    if ($tInicio !== false && $tFim !== false && $tFim < $tInicio) {
      $errors[] = 'A data/hora de fim não pode ser anterior ao início.';
    }
  }

  if (!$errors) {
    q_exec(
      "UPDATE agenda SET titulo=?, inicio=?, fim=?, property_id=?, client_id=?, obs=? WHERE id=?",
      [$titulo, $inicio, ($fim?:null), $property_id, $client_id, ($obs?:null), $id]
    );
    header("Location: {$BASE}/modules/agenda/index.php");
    exit;
  }
}

// ---------- Carrega selects somente para renderização ----------
$clientes = q_all("SELECT id, nome_completo AS nome FROM clients ORDER BY nome_completo ASC");
$imoveis  = q_all("SELECT id, titulo, cidade, uf FROM properties ORDER BY id DESC");

// ---------- Formata campos datetime-local ----------
$inicio_local = $inicio ? str_replace(' ','T',substr($inicio,0,16)) : '';
$fim_local    = $fim    ? str_replace(' ','T',substr($fim,0,16))    : '';

// ---------- LAYOUT PADRÃO ----------
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <!-- Cabeçalho da página (mesmo padrão das outras telas) -->
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-calendar2-week" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Editar compromisso</h1>
      </div>
      <div class="text-muted small mt-1">Atualize as informações do compromisso #<?= (int)$id ?></div>
    </div>
    <div class="d-flex gap-2">
      <a href="<?= $BASE ?>/modules/agenda/index.php" class="btn btn-outline-secondary">
        <i class="bi bi-list-ul"></i> Voltar à lista
      </a>
      <a href="<?= $BASE ?>/modules/agenda/calendario.php" class="btn btn-outline-secondary">
        <i class="bi bi-calendar3"></i> Calendário
      </a>
      <a href="<?= $BASE ?>/modules/agenda/remover.php?id=<?= (int)$id ?>" class="btn btn-outline-danger" onclick="return confirm('Remover este compromisso?');">
        <i class="bi bi-trash"></i> Remover
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Editar compromisso</div>
    <div class="card-body">
      <?php if ($errors): ?>
        <div class="alert alert-danger">
          <?php foreach ($errors as $e) echo '<div>'.h($e).'</div>'; ?>
        </div>
      <?php endif; ?>

      <form method="post" autocomplete="off">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Título <span class="text-danger">*</span></label>
            <input type="text" name="titulo" class="form-control" value="<?= h($titulo) ?>" required>
          </div>

          <div class="col-md-3">
            <label class="form-label">Início <span class="text-danger">*</span></label>
            <input type="datetime-local" name="inicio" class="form-control" value="<?= h($inicio_local) ?>" required>
          </div>

          <div class="col-md-3">
            <label class="form-label">Fim</label>
            <input type="datetime-local" name="fim" class="form-control" value="<?= h($fim_local) ?>">
          </div>

          <div class="col-md-6">
            <label class="form-label">Imóvel (casa)</label>
            <select name="property_id" class="form-select">
              <option value="">— Selecionar (opcional) —</option>
              <?php foreach ($imoveis as $p):
                $rotulo = trim(($p['titulo'].' - '.trim(($p['cidade'].'/'.$p['uf']), '/')));
                $rotulo = $rotulo ?: ('Imóvel #'.(int)$p['id']);
              ?>
                <option value="<?= (int)$p['id'] ?>" <?= ((string)$property_id===(string)$p['id'])?'selected':'' ?>>
                  <?= h($rotulo) ?>
                </option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">Opcional — o compromisso pode ser apenas com cliente, ou apenas interno.</small>
          </div>

          <div class="col-md-6">
            <label class="form-label">Cliente (opcional)</label>
            <select name="client_id" class="form-select">
              <option value="">— Selecionar (opcional) —</option>
              <?php foreach ($clientes as $c): ?>
                <option value="<?= (int)$c['id'] ?>" <?= ((string)$client_id===(string)$c['id'])?'selected':'' ?>>
                  <?= h($c['nome']) ?>
                </option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">Se não quiser vincular a um cliente, deixe em branco.</small>
          </div>

          <div class="col-12">
            <label class="form-label">Observações</label>
            <textarea name="obs" class="form-control" rows="4" placeholder="Anote qualquer detalhe importante"><?= h($obs) ?></textarea>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <button class="btn btn-primary">
            <i class="bi bi-check2"></i> Salvar
          </button>
          <a href="<?= $BASE ?>/modules/agenda/index.php" class="btn btn-outline-secondary">
            Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>