<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

$page_title = 'Permissões do usuário';
$active     = 'usuarios';

// somente admin
rbac_require('usuarios','view', ['message' => 'Somente administradores podem gerenciar permissões.']);

$pdo = function_exists('db') ? db() : (isset($pdo) ? $pdo : (isset($GLOBALS['pdo']) ? $GLOBALS['pdo'] : null));
function q_all($s,$p=[]){ global $pdo; $st=$pdo->prepare($s); $st->execute($p); return $st->fetchAll(PDO::FETCH_ASSOC); }
function q_exec($s,$p=[]){ global $pdo; $st=$pdo->prepare($s); return $st->execute($p); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$user_id = (int)($_GET['user_id'] ?? 0);
if (!$user_id) { http_response_code(400); exit('user_id obrigatório'); }

$me = $_SESSION['user']['id'] ?? 0;

// Ao salvar
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  q_exec("DELETE FROM user_permissions WHERE user_id = ?", [$user_id]);

  $perm_ids = $_POST['perm_id'] ?? [];
  $scopes   = $_POST['scope']   ?? []; // scope[perm_id] = 'none'|'own'|'all'
  foreach ($perm_ids as $pid) {
    $pid = (int)$pid;
    $scope = isset($scopes[$pid]) ? $scopes[$pid] : 'all';
    if (!in_array($scope, ['none','own','all'], true)) $scope = 'all';
    $allow = $scope === 'none' ? 0 : 1;
    q_exec("INSERT INTO user_permissions (user_id, permission_id, allow, scope) VALUES (?,?,?,?)",
      [$user_id, $pid, $allow, $scope]);
  }
  if ($user_id === $me) {
    rbac_reload_permissions($user_id);
  }
  header("Location: " . (defined('BASE_URL')?BASE_URL:'/troyacrm') . "/modules/usuarios/permissoes.php?user_id=" . $user_id);
  exit;
}

// Dados
$user = null; $err='';
try {
  $user = q_all("SELECT id, nome, email, role FROM users WHERE id = ?", [$user_id]);
  $user = $user ? $user[0] : null;
} catch (Throwable $e) { $err = $e->getMessage(); }

$perms = q_all("SELECT * FROM permissions ORDER BY module, action");
$existing = q_all("SELECT permission_id, allow, scope FROM user_permissions WHERE user_id = ?", [$user_id]);
$map = [];
foreach ($existing as $e) { $map[(int)$e['permission_id']] = ['allow'=>(int)$e['allow'],'scope'=>$e['scope']]; }

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-sliders" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Permissões do usuário</h1>
      </div>
      <div class="text-muted small mt-1">
        <?= $user ? h($user['nome'].' • '.$user['email']) : 'Usuário #'.(int)$user_id; ?>
      </div>
    </div>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary" href="<?= (defined('BASE_URL')?BASE_URL:'/troyacrm') ?>/modules/usuarios/index.php">
        <i class="bi bi-arrow-left"></i> Voltar
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Defina o que este usuário pode ver e fazer</div>
    <div class="card-body">
      <?php if (!empty($err)): ?>
        <div class="alert alert-danger"><strong>Erro:</strong> <?= h($err) ?></div>
      <?php endif; ?>

      <?php if (!$perms): ?>
        <div class="empty-state">
          <i class="bi bi-database"></i>
          <h5>Nenhuma permissão cadastrada</h5>
          <p>Rode a migration SQL para popular a tabela <code>permissions</code>.</p>
        </div>
      <?php else: ?>
      <form method="post">
        <div class="table-responsive">
          <table class="table table-dark table-hover align-middle mb-0">
            <thead>
              <tr>
                <th style="width:160px">Módulo</th>
                <th>Ação</th>
                <th style="width:200px">Acesso</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($perms as $p):
                $pid = (int)$p['id'];
                $cur = $map[$pid] ?? null;
                $cur_scope = $cur['scope'] ?? ($p['has_scope'] ? 'own' : 'all');
                $is_on = is_null($cur) ? false : ((int)$cur['allow'] === 1);
              ?>
              <tr>
                <!-- MÓDULO: rótulo amigável + chave técnica embaixo -->
                <td>
                  <div class="fw-semibold"><?= h(rbac_module_label($p['module'])) ?></div>
                  <div class="small text-muted text-uppercase"><?= h($p['module']) ?></div>
                </td>

                <!-- AÇÃO: rótulo amigável + chave técnica embaixo -->
                <td>
                  <div class="fw-semibold"><?= h(rbac_action_label($p['module'], $p['action'])) ?></div>
                  <div class="small text-muted"><?= h($p['action']) ?></div>
                </td>

                <td>
                  <div class="d-flex gap-2 align-items-center">
                    <div class="form-check form-switch">
                      <input class="form-check-input" type="checkbox" id="on<?= $pid ?>" name="perm_id[]" value="<?= $pid ?>" <?= $is_on ? 'checked' : '' ?>>
                      <label class="form-check-label small" for="on<?= $pid ?>">Permitir</label>
                    </div>
                    <?php if ((int)$p['has_scope'] === 1): ?>
                      <select name="scope[<?= $pid ?>]" class="form-select form-select-sm" style="max-width:160px">
                        <option value="none" <?= ($cur_scope==='none')?'selected':'' ?>>Nenhum</option>
                        <option value="own"  <?= ($cur_scope==='own') ?'selected':'' ?>>Próprios</option>
                        <option value="all"  <?= ($cur_scope==='all') ?'selected':'' ?>>Todos</option>
                      </select>
                    <?php else: ?>
                      <input type="hidden" name="scope[<?= $pid ?>]" value="<?= h($cur_scope) ?>">
                    <?php endif; ?>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <div class="mt-3 d-flex gap-2">
          <button class="btn btn-primary"><i class="bi bi-check2"></i> Salvar permissões</button>
          <a class="btn btn-outline-secondary" href="<?= (defined('BASE_URL')?BASE_URL:'/troyacrm') ?>/modules/usuarios/index.php">Cancelar</a>
        </div>
      </form>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>