<?php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('agenda','delete');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);
$id    = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if ($id <= 0) { header("Location: {$BASE}/agenda"); exit; }

$ag = fetch_one("SELECT id, titulo, owner_user_id FROM agenda WHERE id = ?", [$id], true);
if (!$ag) { header("Location: {$BASE}/agenda"); exit; }

$scopeDel = rbac_scope('agenda','delete');
if ($scopeDel === 'own' && isset($ag['owner_user_id']) && (int)$ag['owner_user_id'] !== $me_id) {
    http_response_code(403); exit('Você não tem permissão para excluir este compromisso.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    execute("DELETE FROM agenda WHERE id = ?", [$id]);
    header("Location: {$BASE}/agenda?deleted=1"); exit;
}

$page_title = 'Excluir compromisso';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="card border-danger">
    <div class="card-header bg-danger text-white"><i class="bi bi-trash"></i> Confirmar exclusão</div>
    <div class="card-body">
      <p>Excluir o compromisso <strong><?= htmlspecialchars($ag['titulo']) ?></strong> (ID <?= (int)$ag['id'] ?>)?</p>
      <div class="alert alert-warning"><i class="bi bi-exclamation-triangle"></i> Esta ação não pode ser desfeita.</div>
      <form method="post" class="d-flex gap-2">
        <input type="hidden" name="id" value="<?= (int)$ag['id'] ?>">
        <a href="<?= $BASE ?>/agenda" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Cancelar</a>
        <button class="btn btn-danger"><i class="bi bi-trash"></i> Excluir</button>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>