<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

$page_title = 'Editar usuário';
$active     = 'usuarios';
rbac_require('usuarios','update');

$__pdo = function_exists('db') ? db() : (isset($pdo) ? $pdo : ($GLOBALS['pdo'] ?? null));
if (!($__pdo instanceof PDO)) { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_one($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);$st->execute($p);$r=$st->fetchAll(PDO::FETCH_ASSOC);return $r?$r[0]:null; }
function q_exec($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);return $st->execute($p); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$roles = ['admin'=>'Administrador','manager'=>'Gerente','agent'=>'Corretor','media'=>'Mídia','read'=>'Leitura'];

$id = (int)($_GET['id'] ?? 0);
$u  = $id ? q_one("SELECT * FROM users WHERE id = ?", [$id]) : null;
if (!$u) { http_response_code(404); exit('Usuário não encontrado'); }

$errors = [];
$nome   = trim($_POST['nome']   ?? $u['nome']);
$email  = trim($_POST['email']  ?? $u['email']);
$role   = trim($_POST['role']   ?? ($u['role'] ?? 'agent'));
$ativo  = isset($_POST['ativo']) ? 1 : (int)($u['ativo'] ?? 1);
$senha  = (string)($_POST['senha'] ?? ''); // se vazio, não troca

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if ($nome === '')  $errors[] = 'Informe o nome';
  if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Informe um e-mail válido';
  if (!isset($roles[$role])) $role = ($u['role'] ?? 'agent');

  // e-mail único (ignorando o próprio ID)
  $ex = q_one("SELECT id FROM users WHERE email = ? AND id <> ? LIMIT 1", [$email, $id]);
  if ($ex) $errors[] = 'E-mail já cadastrado por outro usuário';

  if (!$errors) {
    // monta SQL dinâmico para atualizar (com ou sem senha)
    $params = [$nome, $email, $role, $ativo, $id];
    $sql = "UPDATE users SET nome=?, email=?, role=?, ativo=?, updated_at=NOW()";

    if ($senha !== '') {
      if (strlen($senha) < 6) $errors[] = 'A nova senha deve ter ao menos 6 caracteres';
      if (!$errors) {
        if (defined('PASSWORD_ARGON2ID')) $hash = password_hash($senha, PASSWORD_ARGON2ID);
        else $hash = password_hash($senha, PASSWORD_BCRYPT);
        $sql = "UPDATE users SET nome=?, email=?, role=?, ativo=?, senha_hash=?, updated_at=NOW()";
        $params = [$nome, $email, $role, $ativo, $hash, $id];
      }
    }

    if (!$errors) {
      $ok = q_exec($sql." WHERE id=?", $params);
      if ($ok) {
        header("Location: {$BASE}/usuarios");
        exit;
      } else {
        $errors[] = 'Falha ao salvar no banco.';
      }
    }
  }
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-pencil-square" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Editar usuário</h1>
      </div>
      <div class="text-muted small mt-1">#<?= (int)$id ?> — ajuste os dados necessários</div>
    </div>
    <div class="d-flex gap-2">
      <a href="<?= $BASE ?>/usuarios" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Voltar</a>
      <?php if (rbac_can('usuarios','permissoes') || rbac_can('usuarios','view')): ?>
        <a href="<?= $BASE ?>/usuarios/<?= (int)$id ?>/permissoes" class="btn btn-outline-primary">
          <i class="bi bi-sliders"></i> Permissões
        </a>
      <?php endif; ?>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Dados do usuário</div>
    <div class="card-body">
      <?php if ($errors): ?>
        <div class="alert alert-danger"><?php foreach ($errors as $e) echo '<div>'.h($e).'</div>'; ?></div>
      <?php endif; ?>

      <form method="post" autocomplete="off">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Nome <span class="text-danger">*</span></label>
            <input type="text" name="nome" class="form-control" value="<?= h($nome) ?>" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">E-mail <span class="text-danger">*</span></label>
            <input type="email" name="email" class="form-control" value="<?= h($email) ?>" required>
          </div>

          <div class="col-md-4">
            <label class="form-label">Função</label>
            <select name="role" class="form-select">
              <?php foreach ($roles as $k=>$label): ?>
                <option value="<?= h($k) ?>" <?= $role===$k?'selected':'' ?>><?= h($label) ?></option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">Função “admin” tem acesso total.</small>
          </div>

          <div class="col-md-4">
            <label class="form-label">Nova senha</label>
            <input type="password" name="senha" class="form-control" placeholder="deixe em branco para manter">
          </div>

          <div class="col-md-4 d-flex align-items-end">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="ativo" name="ativo" <?= $ativo? 'checked':'' ?>>
              <label class="form-check-label" for="ativo">Ativo</label>
            </div>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <button class="btn btn-primary"><i class="bi bi-check2"></i> Salvar</button>
          <a href="<?= $BASE ?>/usuarios" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>