<?php
require_once __DIR__ . '/../../app/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) { http_response_code(401); header('Content-Type: application/json'); echo json_encode(['error'=>'unauthorized']); exit; }

$__pdo = null;
if (function_exists('db')) { $__pdo = db(); }
elseif (isset($pdo) && $pdo instanceof PDO) { $__pdo = $pdo; }
elseif (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $__pdo = $GLOBALS['pdo']; }
else { http_response_code(500); echo json_encode(['error'=>'pdo_not_found']); exit; }

$st = $__pdo->prepare("
  SELECT a.id, a.titulo, a.inicio, a.fim,
         p.titulo AS p_titulo, p.cidade AS p_cidade, p.uf AS p_uf,
         c.nome_completo AS c_nome
    FROM agenda a
LEFT JOIN properties p ON p.id = a.property_id
LEFT JOIN clients    c ON c.id = a.client_id
ORDER BY a.inicio ASC
LIMIT 1000
");
$st->execute();
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$events = [];
foreach ($rows as $r) {
  $imovel  = $r['p_titulo'] ? ($r['p_titulo'].' - '.trim(($r['p_cidade'].'/'.$r['p_uf']), '/')) : null;
  $cliente = $r['c_nome'] ?: null;
  $title   = implode(' • ', array_filter([$r['titulo'],$imovel,$cliente]));
  $events[] = [
    'id'    => (int)$r['id'],
    'title' => $title,
    'start' => str_replace(' ','T',$r['inicio']),
    'end'   => $r['fim'] ? str_replace(' ','T',$r['fim']) : null,
    'url'   => $BASE . '/modules/agenda/editar.php?id=' . (int)$r['id'],
  ];
}
header('Content-Type: application/json; charset=utf-8');
echo json_encode($events, JSON_UNESCAPED_UNICODE);
