<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: /troyacrm/login");
    exit;
}
require_once __DIR__ . '/../../app/db.php';
$page_title = 'Novo Imóvel';

$erro = null;
$sucesso = false;
$novo_id = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $titulo = trim($_POST['titulo'] ?? '');
        $preco = floatval($_POST['preco'] ?? 0);
        $cidade = trim($_POST['cidade'] ?? '');
        $bairro = trim($_POST['bairro'] ?? '');
        $endereco = trim($_POST['endereco'] ?? '');
        $cep = trim($_POST['cep'] ?? '');
        $uf = trim($_POST['uf'] ?? '');
        $status = trim($_POST['status'] ?? 'rascunho');
        $finalidade = trim($_POST['finalidade'] ?? '');
        $tipo = trim($_POST['tipo'] ?? '');
        $quartos = intval($_POST['quartos'] ?? 0);
        $suites = intval($_POST['suites'] ?? 0);
        $banheiros = intval($_POST['banheiros'] ?? 0);
        $vagas = intval($_POST['vagas'] ?? 0);
        $area_construida = floatval($_POST['area_construida_m2'] ?? 0);
        $area_lote = floatval($_POST['area_lote_m2'] ?? 0);
        $descricao = trim($_POST['descricao'] ?? '');
        $features = $_POST['features'] ?? [];

        if (empty($titulo)) {
            throw new Exception('O título é obrigatório');
        }
        if (empty($endereco)) {
            throw new Exception('O endereço é obrigatório');
        }

        $slug = generate_slug($titulo);

        $sql = "INSERT INTO properties 
                (titulo, slug, preco, cidade, bairro, endereco, cep, uf, status, finalidade, tipo, 
                 quartos, suites, banheiros, vagas, area_construida_m2, area_lote_m2, descricao, created_at)
                VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())";

        execute($sql, [
            $titulo, $slug, $preco, $cidade, $bairro, $endereco, $cep, $uf, $status, $finalidade, $tipo,
            $quartos, $suites, $banheiros, $vagas, $area_construida, $area_lote, $descricao
        ]);
        
        $novo_id = last_insert_id();
        //Registrar log de criação
        execute("INSERT INTO property_logs (property_id, user_id, acao, detalhes) VALUES (?, ?, 'criado', ?)",
        
  [$novo_id, $_SESSION['user_id'], 'Cadastro de novo imóvel']
);

        // Salvar características selecionadas
        if (!empty($features) && is_array($features)) {
            foreach ($features as $feature_id) {
                if (is_numeric($feature_id)) {
                    execute("INSERT IGNORE INTO property_feature_values (property_id, feature_id) VALUES (?, ?)", 
                           [$novo_id, intval($feature_id)]);
                }
            }
        }
        
        $sucesso = true;

    } catch (Exception $e) {
        $erro = $e->getMessage();
    }
}

// Buscar características disponíveis
$features_imovel = fetch_all("SELECT * FROM property_features WHERE categoria = 'imovel' ORDER BY nome ASC", [], true);
$features_condominio = fetch_all("SELECT * FROM property_features WHERE categoria = 'condominio' ORDER BY nome ASC", [], true);

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>

<style>
.dropdown-features {
    max-height: 400px;
    overflow-y: auto;
    padding: 15px;
    min-width: 350px;
}
.feature-group {
    margin-bottom: 15px;
}
.feature-group-title {
    font-weight: bold;
    color: #495057;
    margin-bottom: 10px;
    padding-bottom: 5px;
    border-bottom: 2px solid #dee2e6;
}
.feature-checkbox {
    margin-bottom: 8px;
}
.feature-checkbox label {
    cursor: pointer;
    user-select: none;
}
.feature-checkbox:hover {
    background-color: #f8f9fa;
    border-radius: 4px;
}
#selectedFeaturesCount {
    background-color: #198754;
    color: white;
    border-radius: 50%;
    padding: 2px 8px;
    font-size: 12px;
    font-weight: bold;
    margin-left: 5px;
}
</style>

<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="fw-bold mb-0">
            <i class="bi bi-plus-circle text-success me-2"></i>Novo Imóvel
        </h1>
        <a href="<?=BASE_URL?>/imoveis" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i>Voltar
        </a>
    </div>

    <?php if ($sucesso): ?>
        <div class="alert alert-success">
            <h5><i class="bi bi-check-circle me-2"></i>Imóvel cadastrado com sucesso!</h5>
            <p class="mb-3">Agora você pode adicionar fotos ao imóvel.</p>
            <a href="<?=BASE_URL?>/imoveis/<?=$novo_id?>/fotos" class="btn btn-success">
                <i class="bi bi-images me-2"></i>Adicionar Fotos
            </a>
            <a href="<?=BASE_URL?>/imoveis/novo" class="btn btn-outline-success">
                <i class="bi bi-plus me-2"></i>Cadastrar Outro
            </a>
            <a href="<?=BASE_URL?>/imoveis" class="btn btn-outline-secondary">
                <i class="bi bi-list me-2"></i>Ver Todos
            </a>
        </div>
    <?php endif; ?>

    <?php if ($erro): ?>
        <div class="alert alert-danger">
            <i class="bi bi-exclamation-triangle me-2"></i><?=htmlspecialchars($erro)?>
        </div>
    <?php endif; ?>

    <?php if (!$sucesso): ?>
    <form method="POST" class="card p-4 shadow-sm">
        <div class="row g-3">
            <!-- Título -->
            <div class="col-md-8">
                <label class="form-label fw-bold">Título *</label>
                <input type="text" name="titulo" class="form-control" placeholder="Ex: Casa 3 quartos no Centro" required>
            </div>

            <!-- Preço -->
            <div class="col-md-4">
                <label class="form-label fw-bold">Preço (R$)</label>
                <input type="number" step="0.01" name="preco" class="form-control" placeholder="0.00">
            </div>

            <div class="col-12"><hr></div>

            <!-- Finalidade -->
            <div class="col-md-4">
                <label class="form-label fw-bold">Finalidade</label>
                <select name="finalidade" class="form-select">
                    <option value="">Selecione</option>
                    <option value="venda">Venda</option>
                    <option value="aluguel">Aluguel</option>
                </select>
            </div>

            <!-- Tipo -->
            <div class="col-md-4">
                <label class="form-label fw-bold">Tipo</label>
                <input type="text" name="tipo" class="form-control" placeholder="Ex: Casa, Apartamento">
            </div>

            <!-- Status -->
            <div class="col-md-4">
                <label class="form-label fw-bold">Status</label>
                <select name="status" class="form-select">
                    <option value="publicado">Publicado</option>
                    <option value="rascunho">Rascunho</option>
                    <option value="vendido">Vendido</option>
                    <option value="alugado">Alugado</option>
                </select>
            </div>

            <div class="col-12"><hr></div>

            <!-- CEP -->
            <div class="col-md-3">
                <label class="form-label fw-bold">CEP</label>
                <input type="text" name="cep" id="cep" class="form-control" placeholder="00000-000" maxlength="9">
                <small class="text-muted">Preenche endereço automaticamente</small>
            </div>

            <!-- Endereço -->
            <div class="col-md-9">
                <label class="form-label fw-bold">Endereço *</label>
                <input type="text" name="endereco" id="endereco" class="form-control" placeholder="Rua, número" required>
            </div>

            <!-- Bairro -->
            <div class="col-md-4">
                <label class="form-label fw-bold">Bairro</label>
                <input type="text" name="bairro" id="bairro" class="form-control">
            </div>

            <!-- Cidade -->
            <div class="col-md-6">
                <label class="form-label fw-bold">Cidade</label>
                <input type="text" name="cidade" id="cidade" class="form-control">
            </div>

            <!-- UF -->
            <div class="col-md-2">
                <label class="form-label fw-bold">UF</label>
                <input type="text" name="uf" id="uf" maxlength="2" class="form-control text-uppercase" placeholder="SP">
            </div>

            <div class="col-12"><hr></div>

            <!-- Quartos -->
            <div class="col-md-2">
                <label class="form-label fw-bold">Quartos</label>
                <input type="number" name="quartos" class="form-control" min="0" value="0">
            </div>

            <!-- Suítes -->
            <div class="col-md-2">
                <label class="form-label fw-bold">Suítes</label>
                <input type="number" name="suites" class="form-control" min="0" value="0">
            </div>

            <!-- Banheiros -->
            <div class="col-md-2">
                <label class="form-label fw-bold">Banheiros</label>
                <input type="number" name="banheiros" class="form-control" min="0" value="0">
            </div>

            <!-- Vagas -->
            <div class="col-md-2">
                <label class="form-label fw-bold">Vagas</label>
                <input type="number" name="vagas" class="form-control" min="0" value="0">
            </div>

            <!-- Área Construída -->
            <div class="col-md-2">
                <label class="form-label fw-bold">Área Const. (m²)</label>
                <input type="number" step="0.01" name="area_construida_m2" class="form-control" placeholder="0.00">
            </div>

            <!-- Área do Lote -->
            <div class="col-md-2">
                <label class="form-label fw-bold">Área Lote (m²)</label>
                <input type="number" step="0.01" name="area_lote_m2" class="form-control" placeholder="0.00">
            </div>

            <div class="col-12"><hr></div>

            <!-- Características (Dropdown Multi-Select) -->
            <div class="col-12">
                <label class="form-label fw-bold">Características do Imóvel</label>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle w-100 text-start" type="button" id="dropdownFeatures" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
                        <i class="bi bi-check2-square me-2"></i>Selecionar características
                        <span id="selectedFeaturesCount" style="display:none;">0</span>
                    </button>
                    <div class="dropdown-menu dropdown-features" aria-labelledby="dropdownFeatures">
                        <!-- Características do Imóvel -->
                        <div class="feature-group">
                            <div class="feature-group-title">
                                <i class="bi bi-house-door me-2"></i>Características do Imóvel
                            </div>
                            <?php foreach ($features_imovel as $feature): ?>
                                <div class="form-check feature-checkbox">
                                    <input class="form-check-input feature-check" type="checkbox" name="features[]" value="<?=$feature['id']?>" id="feat<?=$feature['id']?>">
                                    <label class="form-check-label" for="feat<?=$feature['id']?>">
                                        <i class="<?=$feature['icone']?> me-1"></i>
                                        <?=$feature['nome']?>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <!-- Características do Condomínio -->
                        <div class="feature-group">
                            <div class="feature-group-title">
                                <i class="bi bi-building me-2"></i>Características do Condomínio
                            </div>
                            <?php foreach ($features_condominio as $feature): ?>
                                <div class="form-check feature-checkbox">
                                    <input class="form-check-input feature-check" type="checkbox" name="features[]" value="<?=$feature['id']?>" id="feat<?=$feature['id']?>">
                                    <label class="form-check-label" for="feat<?=$feature['id']?>">
                                        <i class="<?=$feature['icone']?> me-1"></i>
                                        <?=$feature['nome']?>
                                    </label>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <small class="text-muted">Selecione todas as características que se aplicam ao imóvel</small>
            </div>

            <div class="col-12"><hr></div>

            <!-- Descrição -->
            <div class="col-12">
                <label class="form-label fw-bold">Descrição</label>
                <textarea name="descricao" rows="4" class="form-control" placeholder="Descreva o imóvel..."></textarea>
            </div>

            <!-- Botões -->
            <div class="col-12 mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="bi bi-check-circle me-2"></i>Cadastrar Imóvel
                </button>
                <a href="<?=BASE_URL?>/imoveis" class="btn btn-outline-secondary btn-lg">
                    <i class="bi bi-x-circle me-2"></i>Cancelar
                </a>
            </div>
        </div>
    </form>
    <?php endif; ?>
</div>

<script>
// Buscar CEP via ViaCEP
document.getElementById('cep').addEventListener('blur', function() {
    const cep = this.value.replace(/\D/g, '');
    if (cep.length === 8) {
        fetch(`https://viacep.com.br/ws/${cep}/json/`)
            .then(res => res.json())
            .then(data => {
                if (!data.erro) {
                    document.getElementById('endereco').value = data.logradouro || '';
                    document.getElementById('bairro').value = data.bairro || '';
                    document.getElementById('cidade').value = data.localidade || '';
                    document.getElementById('uf').value = data.uf || '';
                    document.getElementById('endereco').focus();
                } else {
                    alert('CEP não encontrado');
                }
            })
            .catch(() => alert('Erro ao buscar CEP'));
    }
});

// Contador de características selecionadas
document.querySelectorAll('.feature-check').forEach(checkbox => {
    checkbox.addEventListener('change', updateFeatureCount);
});

function updateFeatureCount() {
    const count = document.querySelectorAll('.feature-check:checked').length;
    const badge = document.getElementById('selectedFeaturesCount');
    if (count > 0) {
        badge.textContent = count;
        badge.style.display = 'inline-block';
    } else {
        badge.style.display = 'none';
    }
}

// Máscara CEP
document.getElementById('cep').addEventListener('input', function(e) {
    let value = e.target.value.replace(/\D/g, '');
    if (value.length > 5) {
        value = value.substring(0, 5) + '-' + value.substring(5, 8);
    }
    e.target.value = value;
});
</script>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
