<?php
// Verificar se está logado
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: " . BASE_URL . "/login.php");
    exit;
}

// Definir título da página (pode ser sobrescrito)
$page_title = $page_title ?? 'Troya CRM';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - Troya CRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --bg-dark: #0d1117;
            --bg-card: #161b22;
            --bg-card-hover: #21262d;
            --border: #30363d;
            --text: #e6edf3;
            --text-muted: #8b949e;
            --text-secondary: #c9d1d9;
            --primary: #238636;
            --primary-hover: #2ea043;
            --success: #238636;
            --info: #58a6ff;
            --warning: #d29922;
            --danger: #f85149;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body { 
            background: var(--bg-dark); 
            color: var(--text); 
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Noto Sans", Helvetica, Arial, sans-serif;
            line-height: 1.6;
            min-height: 100vh;
        }
        
        /* NAVBAR */
        .navbar { 
            background: var(--bg-card) !important; 
            border-bottom: 1px solid var(--border);
            padding: 1rem 0;
        }
        .navbar-brand {
            font-weight: 600;
            font-size: 1.25rem;
            color: var(--text) !important;
        }
        .navbar-text {
            color: var(--text-secondary) !important;
        }
        
        /* CARDS */
        .card { 
            background: var(--bg-card); 
            border: 1px solid var(--border); 
            color: var(--text);
            border-radius: 8px;
            overflow: hidden;
        }
        .card-header {
            background: var(--bg-card-hover) !important;
            border-bottom: 1px solid var(--border);
            padding: 1rem 1.25rem;
            font-weight: 600;
        }
        .card-body {
            padding: 1.25rem;
        }
        
        /* TABLES */
        .table-dark {
            --bs-table-bg: transparent;
            --bs-table-border-color: var(--border);
            color: var(--text);
        }
        .table-dark th {
            background: var(--bg-card-hover);
            border-color: var(--border);
            font-weight: 600;
            color: var(--text-secondary);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 1rem;
        }
        .table-dark td {
            border-color: var(--border);
            vertical-align: middle;
            padding: 1rem;
        }
        .table-hover tbody tr:hover {
            background: var(--bg-card-hover);
        }
        
        /* FORMS */
        .form-control, .form-select, textarea { 
            background: #0d1117; 
            border: 1px solid var(--border); 
            color: var(--text); 
        }
        .form-control:focus, .form-select:focus, textarea:focus {
            background: #0d1117;
            border-color: var(--primary);
            color: var(--text);
            box-shadow: 0 0 0 0.2rem rgba(35, 134, 54, 0.25);
        }
        .form-control::placeholder { 
            color: var(--text-muted); 
        }
        .form-label {
            color: var(--text-secondary);
            font-weight: 500;
            margin-bottom: 0.5rem;
        }
        
        /* BUTTONS */
        .btn {
            border-radius: 6px;
            font-weight: 500;
            padding: 0.5rem 1rem;
            transition: all 0.2s;
        }
        .btn-primary { 
            background: var(--primary); 
            border-color: var(--primary);
            color: white;
        }
        .btn-primary:hover { 
            background: var(--primary-hover); 
            border-color: var(--primary-hover);
            color: white;
        }
        .btn-success {
            background: var(--success);
            border-color: var(--success);
        }
        .btn-success:hover {
            background: var(--primary-hover);
            border-color: var(--primary-hover);
        }
        .btn-outline-light:hover {
            background: rgba(255,255,255,0.1);
        }
        .btn-outline-primary {
            color: var(--info);
            border-color: var(--info);
        }
        .btn-outline-primary:hover {
            background: var(--info);
            border-color: var(--info);
            color: white;
        }
        .btn-outline-secondary {
            color: var(--text-muted);
            border-color: var(--border);
        }
        .btn-outline-secondary:hover {
            background: var(--bg-card-hover);
            border-color: var(--text-muted);
            color: var(--text);
        }
        
        /* BADGES */
        .badge {
            font-size: 0.75rem;
            font-weight: 600;
            padding: 0.35em 0.65em;
        }
        
        /* ALERTS */
        .alert {
            border-radius: 6px;
            border: 1px solid;
        }
        .alert-danger {
            background: rgba(248, 81, 73, 0.1);
            border-color: var(--danger);
            color: var(--text);
        }
        .alert-success {
            background: rgba(35, 134, 54, 0.1);
            border-color: var(--success);
            color: var(--text);
        }
        
        /* TEXT COLORS */
        .text-muted {
            color: var(--text-muted) !important;
        }
        .text-secondary {
            color: var(--text-secondary) !important;
        }
        small, .small {
            color: var(--text-muted) !important;
            font-size: 0.875rem;
        }
        .text-success {
            color: var(--success) !important;
        }
        .text-primary {
            color: var(--info) !important;
        }
        .text-info {
            color: var(--info) !important;
        }
        .text-warning {
            color: var(--warning) !important;
        }
        .text-danger {
            color: var(--danger) !important;
        }
        
        /* EMPTY STATE */
        .empty-state { 
            text-align: center; 
            padding: 3rem 1.5rem;
        }
        .empty-state i { 
            color: var(--text-muted);
            font-size: 4rem; 
            margin-bottom: 1.5rem;
            display: block;
            opacity: 0.5;
        }
        .empty-state h5 {
            color: var(--text-secondary);
            margin-bottom: 0.75rem;
            font-weight: 600;
        }
        .empty-state p {
            color: var(--text-muted);
            margin-bottom: 1.5rem;
        }
        
        /* FORM SECTIONS */
        .form-section { 
            border-bottom: 1px solid var(--border); 
            margin-bottom: 2rem; 
            padding-bottom: 2rem; 
        }
        .form-section:last-child { 
            border-bottom: none; 
            margin-bottom: 0; 
            padding-bottom: 0; 
        }
        .form-section h5 { 
            color: var(--text); 
            margin-bottom: 1rem; 
        }
        
        /* RESPONSIVIDADE */
        @media (max-width: 768px) {
            .empty-state {
                padding: 2rem 1rem;
            }
            .empty-state i {
                font-size: 3rem;
            }
            .card-body {
                padding: 1rem;
            }
            .table-responsive {
                font-size: 0.875rem;
            }
        }
        
        /* ANIMAÇÕES */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .card {
            animation: fadeIn 0.3s ease-out;
        }
    </style>
</head>
<body>
