<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: login.php");
    exit;
}

require_once __DIR__ . '/app/db.php';

$page_title = 'Dashboard';

// Estatísticas
$imoveis_publicados = 0;
$imoveis_total = 0;
$total_clientes = 0;
$ultimos_imoveis = [];
$ultimos_clientes = [];
$conexao_ok = true;
$erro_db = null;

try {
    db()->query("SELECT 1");
    $imoveis_publicados = count_properties('publicado');
    $imoveis_total = count_properties();
    $total_clientes = count_clients();
    $ultimos_imoveis = get_recent_properties(5);
    $ultimos_clientes = get_recent_clients(5);
} catch (Exception $e) {
    $conexao_ok = false;
    $erro_db = $e->getMessage();
}

include __DIR__ . '/layout/header.php';
include __DIR__ . '/layout/nav.php';
?>

<div class="container mt-4 mb-5">
    <!-- HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
        <div>
            <h1 class="mb-1 fw-bold">
                <i class="bi bi-speedometer2 me-2"></i>Dashboard
            </h1>
            <p class="text-muted mb-0">Bem-vindo de volta, <?php echo htmlspecialchars($_SESSION["user_name"] ?? 'Usuário'); ?>!</p>
        </div>
        
        <div class="d-flex align-items-center gap-2 flex-wrap">
            <?php if ($conexao_ok): ?>
                <span class="badge bg-success fs-6 px-3 py-2">
                    <i class="bi bi-check-circle-fill me-1"></i>
                    Banco Conectado
                </span>
            <?php else: ?>
                <span class="badge bg-danger fs-6 px-3 py-2">
                    <i class="bi bi-x-circle-fill me-1"></i>
                    Erro de Banco
                </span>
            <?php endif; ?>
            
            <a href="teste_conexao.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-plug me-1"></i>Testar Conexão
            </a>
        </div>
    </div>

    <?php if ($erro_db): ?>
        <div class="alert alert-danger mb-4">
            <h5 class="mb-2"><i class="bi bi-exclamation-triangle-fill me-2"></i>Erro de Conexão</h5>
            <p class="mb-3"><?php echo htmlspecialchars($erro_db); ?></p>
        </div>
    <?php endif; ?>

    <!-- ESTATÍSTICAS -->
    <div class="row g-4 mb-5">
        <div class="col-lg-3 col-md-6">
            <a href="<?php echo BASE_URL; ?>/imoveis" class="stat-card card text-decoration-none">
                <div class="card-body text-center">
                    <i class="bi bi-building display-4 text-success"></i>
                    <h2 class="mt-3 mb-1"><?php echo $imoveis_publicados; ?></h2>
                    <p class="text-muted mb-0">Imóveis Publicados</p>
                    <small class="text-success fw-semibold">
                        <?php echo $imoveis_total - $imoveis_publicados; ?> em rascunho
                    </small>
                </div>
            </a>
        </div>

        <div class="col-lg-3 col-md-6">
            <a href="<?php echo BASE_URL; ?>/clientes" class="stat-card card text-decoration-none">
                <div class="card-body text-center">
                    <i class="bi bi-people display-4 text-primary"></i>
                    <h2 class="mt-3 mb-1"><?php echo $total_clientes; ?></h2>
                    <p class="text-muted mb-0">Total de Clientes</p>
                    <small class="text-primary fw-semibold">
                        Cadastrados no sistema
                    </small>
                </div>
            </a>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="stat-card card">
                <div class="card-body text-center">
                    <i class="bi bi-calendar-check display-4 text-info"></i>
                    <h2 class="mt-3 mb-1">0</h2>
                    <p class="text-muted mb-0">Visitas Agendadas</p>
                    <small class="text-info fw-semibold">
                        Em breve disponível
                    </small>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="stat-card card">
                <div class="card-body text-center">
                    <i class="bi bi-graph-up display-4 text-warning"></i>
                    <h2 class="mt-3 mb-1">0</h2>
                    <p class="text-muted mb-0">Propostas</p>
                    <small class="text-warning fw-semibold">
                        Em breve disponível
                    </small>
                </div>
            </div>
        </div>
    </div>

    <?php if ($conexao_ok): ?>
        <!-- RECENTES -->
        <div class="row g-4">
            <!-- ÚLTIMOS IMÓVEIS -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-house-door me-2 text-success"></i>
                            Últimos Imóveis
                        </h5>
                        <a href="<?php echo BASE_URL; ?>/imoveis" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-grid me-1"></i>Ver Todos
                        </a>
                    </div>
                    
                    <div class="card-body p-0">
                        <?php if (empty($ultimos_imoveis)): ?>
                            <div class="empty-state">
                                <i class="bi bi-house-door"></i>
                                <h5>Nenhum imóvel cadastrado</h5>
                                <p>Comece adicionando seu primeiro imóvel ao sistema!</p>
                                <a href="<?php echo BASE_URL; ?>/imoveis/novo" class="btn btn-success">
                                    <i class="bi bi-plus-circle me-2"></i>Cadastrar Imóvel
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-dark table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th>Título</th>
                                            <th>Preço</th>
                                            <th>Cidade</th>
                                            <th>Status</th>
                                            <th>Data</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($ultimos_imoveis as $imovel): ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo htmlspecialchars($imovel['titulo']); ?></strong>
                                            </td>
                                            <td>
                                                <span class="text-success fw-bold">
                                                    <?php echo format_money($imovel['preco']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo htmlspecialchars($imovel['cidade']); ?></td>
                                            <td>
                                                <span class="badge <?php 
                                                    echo $imovel['status'] === 'publicado' ? 'bg-success' : 
                                                    ($imovel['status'] === 'rascunho' ? 'bg-warning text-dark' : 'bg-secondary');
                                                ?>">
                                                    <?php echo ucfirst($imovel['status']); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <small class="text-muted">
                                                    <?php echo date('d/m/Y', strtotime($imovel['created_at'])); ?>
                                                </small>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- ÚLTIMOS CLIENTES -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="bi bi-people me-2 text-primary"></i>
                            Últimos Clientes
                        </h5>
                        <a href="<?php echo BASE_URL; ?>/clientes" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-people me-1"></i>Ver Todos
                        </a>
                    </div>
                    
                    <div class="card-body p-0">
                        <?php if (empty($ultimos_clientes)): ?>
                            <div class="empty-state">
                                <i class="bi bi-person-plus"></i>
                                <h5>Nenhum cliente cadastrado</h5>
                                <p>Adicione seu primeiro cliente para começar!</p>
                                <a href="<?php echo BASE_URL; ?>/clientes/novo" class="btn btn-success">
                                    <i class="bi bi-plus-circle me-2"></i>Cadastrar Cliente
                                </a>
                            </div>
                        <?php else: ?>
                            <ul class="list-group list-group-flush">
                                <?php foreach ($ultimos_clientes as $cliente): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong><?php echo htmlspecialchars($cliente['nome']); ?></strong>
                                        <?php if (!empty($cliente['email'])): ?>
                                            <br><small><?php echo htmlspecialchars($cliente['email']); ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($cliente['whatsapp'])): ?>
                                        <a href="https://wa.me/55<?php echo preg_replace('/\D/', '', $cliente['whatsapp']); ?>" 
                                           class="btn btn-sm btn-success" target="_blank" title="WhatsApp">
                                            <i class="bi bi-whatsapp"></i>
                                        </a>
                                    <?php endif; ?>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- PRÓXIMOS PASSOS -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class="bi bi-lightbulb me-2 text-warning"></i>
                            Próximos Passos
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 rounded bg-success bg-opacity-10">
                                    <div class="bg-success text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-check-lg"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Conexão OK</h6>
                                        <small>Banco de dados conectado com sucesso</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 rounded bg-warning bg-opacity-10">
                                    <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-plus-circle"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Adicionar Conteúdo</h6>
                                        <small>Cadastre imóveis e clientes</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center p-3 rounded bg-info bg-opacity-10">
                                    <div class="bg-info text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-gear"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-semibold">Configurar Site</h6>
                                        <small>Integre com troyasite</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- INSTRUÇÕES DE INSTALAÇÃO -->
        <div class="alert alert-warning">
            <h5><i class="bi bi-exclamation-triangle me-2"></i>Erro de Conexão com Banco</h5>
            <p class="mb-2">Complete a configuração seguindo estes passos:</p>
            <ol class="mb-0">
                <li>Verifique as credenciais em <code>config/config.php</code></li>
                <li>Confirme que o banco <code>ztr_troya_crm</code> existe</li>
                <li>Teste a conexão novamente</li>
            </ol>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/layout/footer.php'; ?>
