<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('atendimentos','update');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
$CSRF = $_SESSION['csrf'];

$id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if ($id <= 0) { header('Location: '.$BASE.'/modules/atendimentos/index.php'); exit; }

$att = fetch_one("SELECT * FROM interactions WHERE id = ?", [$id], true);
if (!$att) { header('Location: '.$BASE.'/modules/atendimentos/index.php'); exit; }

/* RBAC escopo */
$scopeU = rbac_scope('atendimentos','update'); // 'own' | 'all'
if ($scopeU === 'own') {
  $owner = (int)($att['owner_user_id'] ?? 0);
  $fallback = (int)($att['created_by'] ?? 0);
  if (!in_array($me_id, [$owner, $fallback], true)) {
    http_response_code(403); exit('Sem permissão para editar este atendimento.');
  }
}

$erros = [];
$ok    = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!hash_equals($CSRF, (string)($_POST['csrf'] ?? ''))) {
    $erros[] = 'CSRF inválido.'; 
  } else {
    $status = $_POST['status'] ?? '';
    $nota   = trim($_POST['nota'] ?? '');
    $nfa    = trim($_POST['next_followup_at'] ?? '');

    $valid = ['novo','em_atendimento','negociacao','finalizado'];
    if (!in_array($status, $valid, true)) $erros[] = 'Status inválido.';

    // normaliza datetime-local
    $nfa_sql = null;
    if ($nfa !== '') {
      $ts = strtotime($nfa);
      if ($ts !== false) $nfa_sql = date('Y-m-d H:i:s', $ts);
    }

    if (!$erros) {
      try {
        execute("UPDATE interactions
                    SET status = ?, nota = ?, next_followup_at = ?, updated_at = NOW()
                  WHERE id = ?",
                [$status, $nota !== '' ? $nota : null, $nfa_sql, $id]);
        $ok = true;
        header('Location: '.$BASE.'/modules/atendimentos/visualizar.php?id='.$id.'&updated=1');
        exit;
      } catch (Throwable $e) {
        $erros[] = 'Erro ao salvar: '.$e->getMessage();
      }
    }
  }
}

/* recarrega dados */
$att = fetch_one("SELECT i.*, c.nome_completo AS cliente_nome
                  FROM interactions i
                  LEFT JOIN clients c ON c.id = i.client_id
                  WHERE i.id = ?", [$id], true);

$page_title = 'Editar Atendimento';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0"><i class="bi bi-pencil-square me-2"></i>Editar Atendimento</h1>
    <div class="d-flex gap-2">
      <a href="<?=$BASE?>/modules/atendimentos/visualizar.php?id=<?=$id?>" class="btn btn-outline-light"><i class="bi bi-eye"></i> Visualizar</a>
      <a href="<?=$BASE?>/modules/atendimentos/index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Voltar</a>
    </div>
  </div>

  <?php if ($erros): ?>
    <div class="alert alert-danger">
      <strong>Erro:</strong><br><?=implode('<br>', array_map('htmlspecialchars', $erros))?>
    </div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <form method="post" class="row g-3">
        <input type="hidden" name="id" value="<?=$id?>">
        <input type="hidden" name="csrf" value="<?=htmlspecialchars($CSRF)?>">

        <div class="col-12">
          <label class="form-label">Cliente</label>
          <input type="text" class="form-control" value="<?=htmlspecialchars($att['cliente_nome'] ?? '—')?>" disabled>
        </div>

        <div class="col-md-4">
          <label class="form-label">Status</label>
          <select name="status" class="form-select" required>
            <?php
              $opts = [
                'novo'           => 'Novo',
                'em_atendimento' => 'Em Atendimento',
                'negociacao'     => 'Negociação',
                'finalizado'     => 'Finalizado'
              ];
              foreach ($opts as $val=>$lab):
            ?>
              <option value="<?=$val?>" <?=$att['status']===$val?'selected':''?>><?=$lab?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-md-4">
          <label class="form-label">Próxima ação</label>
          <?php
            $nfa_val = '';
            if (!empty($att['next_followup_at'])) {
              $nfa_val = date('Y-m-d\TH:i', strtotime($att['next_followup_at']));
            }
          ?>
          <input type="datetime-local" name="next_followup_at" class="form-control" value="<?=$nfa_val?>">
        </div>

        <div class="col-12">
          <label class="form-label">Nota</label>
          <textarea name="nota" rows="4" class="form-control" placeholder="Observações..."><?=htmlspecialchars($att['nota'] ?? '')?></textarea>
        </div>

        <div class="col-12 d-flex justify-content-end gap-2">
          <a href="<?=$BASE?>/modules/atendimentos/index.php" class="btn btn-secondary"><i class="bi bi-x-circle"></i> Cancelar</a>
          <button class="btn btn-primary"><i class="bi bi-check2-circle"></i> Salvar</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>