<?php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

/* Admin/Gerente apenas */
if (!rbac_can('admin','access') && rbac_scope('atendimentos','view')!=='all') {
  http_response_code(403); exit('Sem permissão.');
}

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

$page_title = 'Admin · Alertas de Inatividade';

/* Lê X dias (default 3) */
$days = 3;
try {
  $cfg = fetch_one("SELECT `value` FROM system_configs WHERE `key`='alerts_inactivity_days' LIMIT 1", [], true);
  if ($cfg && is_numeric($cfg['value'])) { $days = max(1, (int)$cfg['value']); }
} catch (Throwable $e) {}

$rows = [];
try {
  $rows = fetch_all("
    SELECT 
      i.id,
      i.client_id,
      i.status,
      i.next_followup_at,
      c.nome_completo AS cliente_nome,
      u.nome          AS owner_nome,
      COALESCE(
        (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
        i.last_activity_at,
        i.updated_at,
        i.created_at
      ) AS last_dt,
      TIMESTAMPDIFF(
        DAY,
        COALESCE(
          (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
          i.last_activity_at,
          i.updated_at,
          i.created_at
        ),
        NOW()
      ) AS gap_days
    FROM interactions i
    LEFT JOIN clients c ON c.id = i.client_id
    LEFT JOIN users   u ON u.id = i.owner_user_id
    WHERE i.status <> 'finalizado'
      AND TIMESTAMPDIFF(
            DAY,
            COALESCE(
              (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
              i.last_activity_at,
              i.updated_at,
              i.created_at
            ),
            NOW()
          ) >= ?
    ORDER BY gap_days DESC, last_dt ASC
    LIMIT 300
  ", [$days], true) ?: [];
} catch (Throwable $e) {
  $rows = [];
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0"><i class="bi bi-bell me-2 text-warning"></i>Alertas de Inatividade</h1>
    <a class="btn btn-outline-secondary" href="<?=$BASE?>/admin"><i class="bi bi-arrow-left"></i> Admin</a>
  </div>

  <div class="alert alert-warning">
    Mostrando atendimentos com <strong><?= (int)$days ?></strong> dia(s) ou mais sem atualização (status diferente de <em>finalizado</em>).
  </div>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-dark table-hover align-middle mb-0">
        <thead>
          <tr>
            <th style="width:80px">ID</th>
            <th>Cliente</th>
            <th style="width:200px">Responsável</th>
            <th style="width:160px">Status</th>
            <th style="width:190px">Última atividade</th>
            <th style="width:160px">Gap (dias)</th>
            <th style="width:160px" class="text-end">Ações</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td>#<?= (int)$r['id'] ?></td>
            <td>
              <strong><?= htmlspecialchars($r['cliente_nome'] ?? '—') ?></strong>
            </td>
            <td><?= htmlspecialchars($r['owner_nome'] ?? '—') ?></td>
            <td><span class="badge bg-<?= ['novo'=>'secondary','em_atendimento'=>'info','negociacao'=>'warning','finalizado'=>'success'][$r['status']] ?? 'secondary' ?>">
              <?= htmlspecialchars(ucfirst(str_replace('_',' ',$r['status']))) ?>
            </span></td>
            <td><?= $r['last_dt'] ? date('d/m/Y H:i', strtotime($r['last_dt'])) : '—' ?></td>
            <td><?= (int)$r['gap_days'] ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-light" href="<?=$BASE?>/atendimentos/visualizar?id=<?=(int)$r['id']?>"><i class="bi bi-eye"></i></a>
            </td>
          </tr>
        <?php endforeach; if (!$rows): ?>
          <tr><td colspan="7" class="text-center text-muted py-4">Sem alertas no momento.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>