<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

/* RBAC: precisa de permissão para transferir dono */
rbac_require('admin','transfer_owner');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

/* CSRF */
if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
$CSRF = $_SESSION['csrf'];

$ok=null; $err=null; $info=null;

try {
  $users = fetch_all("SELECT id, nome FROM users ORDER BY nome ASC", [], true) ?: [];
} catch (Throwable $e) {
  $users = [];
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
  try {
    if (!hash_equals($CSRF, (string)($_POST['csrf'] ?? ''))) { throw new Exception('CSRF inválido'); }

    $mode = $_POST['mode'] ?? 'single';

    if ($mode === 'single') {
      $client_id = (int)($_POST['client_id'] ?? 0);
      $to_id     = (int)($_POST['to_id'] ?? 0);
      if ($client_id<=0 || $to_id<=0) throw new Exception('Informe cliente e novo responsável.');

      $aff = execute("UPDATE clients SET owner_user_id = ? WHERE id = ?", [$to_id, $client_id]);
      execute("INSERT INTO ownership_transfers (entity_type, client_id, from_user_id, to_user_id, performed_by, created_at) VALUES ('client', ?, NULL, ?, ?, NOW())", [$client_id, $to_id, $me_id]);

      $ok = "Cliente #{$client_id} reatribuído para usuário #{$to_id}.";
    } else {
      // bulk
      $from_id = (int)($_POST['from_id'] ?? 0);
      $to_id   = (int)($_POST['to_id'] ?? 0);
      if ($from_id<=0 || $to_id<=0) throw new Exception('Selecione origem e destino.');
      if ($from_id === $to_id) throw new Exception('Origem e destino não podem ser iguais.');

      // Conta afetados (preview)
      $total = fetch_one("SELECT COUNT(*) AS c FROM clients WHERE owner_user_id = ?", [$from_id], true);
      $count = (int)($total['c'] ?? 0);

      $aff = execute("UPDATE clients SET owner_user_id = ? WHERE owner_user_id = ?", [$to_id, $from_id]);
      execute("INSERT INTO ownership_transfers (entity_type, client_id, from_user_id, to_user_id, performed_by, created_at, bulk_count) VALUES ('client.bulk', NULL, ?, ?, ?, NOW(), ?)", [$from_id, $to_id, $me_id, $count]);

      $ok = "Reatribuição em massa concluída. Registros afetados: {$count}.";
    }

  } catch (Throwable $e) {
    $err = $e->getMessage();
  }
}

$page_title = 'Admin • Reatribuir responsável';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<style>
small.muted { color:#adb5bd; }
</style>

<div class="container my-4">
  <?php if ($ok): ?>
    <div class="alert alert-success alert-dismissible fade show"><i class="bi bi-check-circle me-2"></i><?=htmlspecialchars($ok)?><button class="btn-close" data-bs-dismiss="alert"></button></div>
  <?php endif; ?>
  <?php if ($err): ?>
    <div class="alert alert-danger alert-dismissible fade show"><i class="bi bi-exclamation-triangle me-2"></i><?=htmlspecialchars($err)?><button class="btn-close" data-bs-dismiss="alert"></button></div>
  <?php endif; ?>

  <h1 class="h4 mb-3"><i class="bi bi-arrow-left-right me-2"></i>Reatribuir responsável</h1>

  <div class="row g-3">
    <div class="col-lg-6">
      <div class="card">
        <div class="card-header"><strong>Reatribuição por cliente (individual)</strong></div>
        <div class="card-body">
          <form method="post" class="row g-3">
            <input type="hidden" name="csrf" value="<?=$CSRF?>">
            <input type="hidden" name="mode" value="single">
            <div class="col-md-5">
              <label class="form-label">ID do Cliente</label>
              <input type="number" class="form-control" name="client_id" min="1" required>
              <small class="muted">Você pode localizar o ID na listagem de clientes.</small>
            </div>
            <div class="col-md-7">
              <label class="form-label">Novo responsável</label>
              <select name="to_id" class="form-select" required>
                <option value="">Selecione...</option>
                <?php foreach ($users as $u): ?>
                  <option value="<?=$u['id']?>"><?=htmlspecialchars($u['nome'])?> (#<?=$u['id']?>)</option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-12">
              <button class="btn btn-primary"><i class="bi bi-check2-circle me-1"></i>Reatribuir</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card">
        <div class="card-header"><strong>Reatribuição em massa (por responsável)</strong></div>
        <div class="card-body">
          <form method="post" class="row g-3">
            <input type="hidden" name="csrf" value="<?=$CSRF?>">
            <input type="hidden" name="mode" value="bulk">
            <div class="col-md-6">
              <label class="form-label">Responsável atual (origem)</label>
              <select name="from_id" class="form-select" required>
                <option value="">Selecione...</option>
                <?php foreach ($users as $u): ?>
                  <option value="<?=$u['id']?>"><?=htmlspecialchars($u['nome'])?> (#<?=$u['id']?>)</option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">Novo responsável (destino)</label>
              <select name="to_id" class="form-select" required>
                <option value="">Selecione...</option>
                <?php foreach ($users as $u): ?>
                  <option value="<?=$u['id']?>"><?=htmlspecialchars($u['nome'])?> (#<?=$u['id']?>)</option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-12">
              <button class="btn btn-warning"><i class="bi bi-arrow-left-right me-1"></i>Reatribuir em massa</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <div class="mt-3">
    <a class="btn btn-secondary" href="<?=$BASE?>/admin"><i class="bi bi-arrow-left"></i> Voltar</a>
  </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
