<?php
// PÁGINA DE IMÓVEL
$id = $_GET['id'] ?? 1;

// Dados simulados (depois você conecta com o banco)
$imoveis = [
    1 => [
        'titulo' => 'Casa 3 Quartos no Centro',
        'preco' => 850000,
        'tipo' => 'Casa',
        'area' => '180m²',
        'quartos' => 3,
        'banheiros' => 2,
        'vagas' => 2,
        'endereco' => 'Rua das Flores, 123 - Centro, Belo Horizonte/MG',
        'descricao' => 'Casa ampla e bem localizada no coração da cidade. Possui 3 quartos amplos, suíte principal com closet, sala de estar conjugada com cozinha americana moderna. Possui área de lazer com piscina aquecida e churrasqueira a gás. Garagem para 2 carros.',
        'fotos' => ['https://via.placeholder.com/800x500/161b22/e6edf3?text=Foto+1', 'https://via.placeholder.com/800x500/161b22/e6edf3?text=Foto+2']
    ],
    2 => [
        'titulo' => 'Apartamento 2 Quartos Savassi',
        'preco' => 2500,
        'tipo' => 'Apartamento',
        'area' => '85m²',
        'quartos' => 2,
        'banheiros' => 1,
        'vagas' => 1,
        'endereco' => 'Av. Getúlio Vargas, 456 - Savassi, Belo Horizonte/MG',
        'descricao' => 'Apartamento moderno na Savassi com acabamentos de alto padrão. Localização privilegiada com fácil acesso a comércio e serviços.',
        'fotos' => ['https://via.placeholder.com/800x500/161b22/e6edf3?text=Apartamento+Savassi']
    ]
];

$imovel = $imoveis[$id] ?? $imoveis[1];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($imovel['titulo']) ?> - Troya Imóveis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root { --primary: #238636; --dark: #0d1117; --darker: #161b22; --border: #30363d; --text: #e6edf3; }
        body { background: var(--dark); color: var(--text); }
        .hero-detail { background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 100%); padding: 3rem 0; }
        .gallery img { height: 300px; object-fit: cover; border-radius: 8px; }
        .btn-whatsapp { background: #25D366; border-color: #25D366; color: white; }
        .btn-whatsapp:hover { background: #128C7E; border-color: #128C7E; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">Troya Imóveis</a>
            <a href="index.php" class="btn btn-outline-light">← Voltar aos Imóveis</a>
        </div>
    </nav>

    <section class="hero-detail">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h1><?= htmlspecialchars($imovel['titulo']) ?></h1>
                    <p class="lead mb-0"><i class="bi bi-geo-alt me-2"></i><?= htmlspecialchars($imovel['endereco']) ?></p>
                </div>
                <div class="col-md-4 text-end">
                    <h2 class="text-success mb-0">
                        <?= $imovel['preco'] > 10000 ? 'R$ ' . number_format($imovel['preco'], 0, ',', '.') : 'R$ ' . number_format($imovel['preco'], 2, ',', '.') . '/mês' ?>
                    </h2>
                    <small class="text-muted"><?= $imovel['tipo'] ?> • <?= $imovel['area'] ?></small>
                </div>
            </div>
        </div>
    </section>

    <div class="container my-5">
        <div class="row">
            <!-- GALERIA -->
            <div class="col-md-8 mb-4">
                <h3>Fotos</h3>
                <div id="carouselImovel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <?php foreach ($imovel['fotos'] as $index => $foto): ?>
                        <div class="carousel-item <?= $index === 0 ? 'active' : '' ?>">
                            <img src="<?= htmlspecialchars($foto) ?>" class="d-block w-100" alt="<?= htmlspecialchars($imovel['titulo']) ?>">
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <button class="carousel-control-prev" type="button" data-bs-target="#carouselImovel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon"></span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#carouselImovel" data-bs-slide="next">
                        <span class="carousel-control-next-icon"></span>
                    </button>
                </div>

                <h3 class="mt-4">Descrição</h3>
                <p><?= nl2br(htmlspecialchars($imovel['descricao'])) ?></p>

                <h5 class="mt-4">Características</h5>
                <div class="row">
                    <div class="col-md-3"><i class="bi bi-door-open me-2 text-primary"></i><?= $imovel['quartos'] ?> Quartos</div>
                    <div class="col-md-3"><i class="bi bi-basket me-2 text-primary"></i><?= $imovel['banheiros'] ?> Banheiros</div>
                    <div class="col-md-3"><i class="bi bi-car-front me-2 text-primary"></i><?= $imovel['vagas'] ?> Vagas</div>
                    <div class="col-md-3"><i class="bi bi-rulers me-2 text-primary"></i><?= $imovel['area'] ?></div>
                </div>
            </div>

            <!-- CONTATO LATERAL -->
            <div class="col-md-4">
                <div class="card bg-darker border-secondary">
                    <div class="card-body">
                        <h5><i class="bi bi-telephone me-2"></i>Agende uma Visita</h5>
                        <p class="text-muted">Fale com nossos corretores</p>
                        
                        <a href="https://wa.me/5531991234567?text=Olá! Tenho interesse na <?= urlencode($imovel['titulo']) ?>" 
                           class="btn btn-whatsapp w-100 mb-3">
                            <i class="bi bi-whatsapp me-2"></i>WhatsApp
                        </a>
                        
                        <a href="tel:+5531991234567" class="btn btn-outline-success w-100 mb-3">
                            <i class="bi bi-telephone me-2"></i>Ligar
                        </a>
                        
                        <a href="mailto:contato@troyaimoveis.com" class="btn btn-outline-primary w-100">
                            <i class="bi bi-envelope me-2"></i>Email
                        </a>
                    </div>
                </div>

                <div class="card bg-darker border-secondary mt-4">
                    <div class="card-body">
                        <h6>Informações do Imóvel</h6>
                        <ul class="list-unstyled small">
                            <li><strong>Tipo:</strong> <?= htmlspecialchars($imovel['tipo']) ?></li>
                            <li><strong>Área:</strong> <?= $imovel['area'] ?></li>
                            <li><strong>Quartos:</strong> <?= $imovel['quartos'] ?></li>
                            <li><strong>Status:</strong> Disponível</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-center py-4 mt-5">
        <div class="container">
            <p>&copy; 2024 Troya Imóveis. Todos os direitos reservados.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
